/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.JavaScriptFile;

public class CheckUtils {
    private CheckUtils() {
    }

    public static String asString(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.TOKEN})) {
            return ((SyntaxToken)tree).text();
        }
        StringBuilder sb = new StringBuilder();
        Iterator treeIterator = ((JavaScriptTree)tree).childrenIterator();
        SyntaxToken prevToken = null;
        while (treeIterator.hasNext()) {
            Tree child = (Tree)treeIterator.next();
            if (child == null) continue;
            CheckUtils.appendChild(sb, prevToken, child);
            prevToken = child.lastToken();
        }
        return sb.toString();
    }

    private static void appendChild(StringBuilder sb, @Nullable SyntaxToken prevToken, Tree child) {
        SyntaxToken firstToken;
        if (prevToken != null && CheckUtils.isSpaceRequired(prevToken, firstToken = child.firstToken())) {
            sb.append(" ");
        }
        sb.append(CheckUtils.asString(child));
    }

    private static boolean isSpaceRequired(SyntaxToken prevToken, SyntaxToken token) {
        return token.line() > prevToken.line() || prevToken.column() + prevToken.text().length() < token.column();
    }

    public static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return CheckUtils.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }

    public static Tree parentIgnoreParentheses(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return CheckUtils.parentIgnoreParentheses(parent);
        }
        return parent;
    }

    public static ControlFlowGraph buildControlFlowGraph(Tree tree) {
        Tree parent = tree;
        while (!parent.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            if (parent.is(new Kinds[]{Tree.Kind.BLOCK}) && parent.parent().is(new Kinds[]{KindSet.FUNCTION_KINDS})) {
                return ControlFlowGraph.build((BlockTree)((BlockTree)parent));
            }
            parent = parent.parent();
        }
        return ControlFlowGraph.build((ScriptTree)((ScriptTree)parent));
    }

    public static boolean isDescendant(Tree tree, Tree potentialParent) {
        for (Tree parent = tree; parent != null; parent = parent.parent()) {
            if (!parent.equals(potentialParent)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Tree getFirstAncestor(Tree tree, Kinds ... kind) {
        for (Tree ancestor = tree.parent(); ancestor != null; ancestor = ancestor.parent()) {
            if (!ancestor.is(kind)) continue;
            return ancestor;
        }
        return null;
    }

    public static List<String> readLines(JavaScriptFile file) {
        List<String> list;
        block8: {
            BufferedReader reader = CheckUtils.newBufferedReader(file);
            try {
                list = reader.lines().collect(Collectors.toList());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read file " + file.uri(), e);
                }
            }
            reader.close();
        }
        return list;
    }

    private static BufferedReader newBufferedReader(JavaScriptFile file) throws IOException {
        return new BufferedReader(new StringReader(file.contents()));
    }
}

