/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.EslintBasedCheck;
import org.sonar.plugins.javascript.api.JavaScriptRule;
import org.sonar.plugins.javascript.api.TypeScriptRule;

@JavaScriptRule
@TypeScriptRule
@Rule(key="S3524")
public class ArrowFunctionConventionCheck
implements EslintBasedCheck {
    private static final boolean DEFAULT_PARAMETER_PARENS = false;
    private static final boolean DEFAULT_BODY_BRACES = false;
    @RuleProperty(key="parameter_parens", description="True to require parentheses around parameters. False to forbid them for single parameter.", defaultValue="false")
    boolean parameterParens = false;
    @RuleProperty(key="body_braces", description="True to require curly braces around function body. False to forbid them for single-return bodies.", defaultValue="false")
    boolean bodyBraces = false;

    @Override
    public String eslintKey() {
        return "arrow-function-convention";
    }

    @Override
    public List<Object> configurations() {
        return Collections.singletonList(new Config(this.parameterParens, this.bodyBraces));
    }

    private static class Config {
        boolean requireParameterParentheses;
        boolean requireBodyBraces;

        Config(boolean requireParameterParentheses, boolean requireBodyBraces) {
            this.requireParameterParentheses = requireParameterParentheses;
            this.requireBodyBraces = requireBodyBraces;
        }
    }
}

