/*
 * SonarQube JavaScript Plugin
 * Copyright (C) 2011-2016 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class YieldExpressionTreeImpl extends JavaScriptTree implements YieldExpressionTree {

  private InternalSyntaxToken yieldKeyword;
  @Nullable
  private final InternalSyntaxToken star;
  private final ExpressionTree argument;

  public YieldExpressionTreeImpl(InternalSyntaxToken yieldKeyword) {
    this.yieldKeyword = yieldKeyword;
    this.star = null;
    this.argument = null;

  }

  public YieldExpressionTreeImpl(InternalSyntaxToken star, ExpressionTree argument) {
    this.star = star;
    this.argument = argument;

  }

  public YieldExpressionTreeImpl(ExpressionTree argument) {
    this.star = null;
    this.argument = argument;

  }

  public YieldExpressionTreeImpl complete(InternalSyntaxToken yieldKeyword) {
    this.yieldKeyword = yieldKeyword;

    return this;
  }

  @Override
  public SyntaxToken yieldKeyword() {
    return yieldKeyword;
  }

  @Nullable
  @Override
  public SyntaxToken star() {
    return star;
  }

  @Override
  public ExpressionTree argument() {
    return argument;
  }

  @Override
  public Kind getKind() {
    return Kind.YIELD_EXPRESSION;
  }

  @Override
  public Iterator<Tree> childrenIterator() {
    return Iterators.forArray(yieldKeyword, star, argument);
  }

  @Override
  public void accept(TreeVisitor visitor) {
    visitor.visitYieldExpression(this);
  }

  @Override
  public TypeSet types() {
    return TypeSet.emptyTypeSet();
  }
}
