/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.source.Highlightable;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.tree.impl.expression.LiteralTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.visitors.SubscriptionTreeVisitor;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class HighlighterVisitor
extends SubscriptionTreeVisitor {
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fileSystem;
    private Highlightable.HighlightingBuilder highlighting;
    private SourceFileOffsets offsets;
    private static final Tree.Kind[] METHODS = new Tree.Kind[]{Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD, Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD};
    private static final Logger LOG = LoggerFactory.getLogger(HighlighterVisitor.class);

    public HighlighterVisitor(ResourcePerspectives resourcePerspectives, FileSystem fileSystem) {
        this.resourcePerspectives = resourcePerspectives;
        this.fileSystem = fileSystem;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])METHODS).add((Object[])new Tree.Kind[]{Tree.Kind.LET_DECLARATION, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.TOKEN}).build();
    }

    @Override
    public void scanFile(TreeVisitorContext context) {
        this.highlighting = this.initHighlighting(context.getFile());
        if (this.highlighting != null) {
            super.scanFile(context);
            this.stopHighlighting();
        }
    }

    private void stopHighlighting() {
        this.highlighting.done();
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(METHODS)) {
            SyntaxToken token = ((MethodDeclarationTree)tree).staticToken();
            if (token != null) {
                this.highlight(this.offsets.startOffset(token), this.offsets.endOffset(token), "k");
            }
        } else if (tree.is(Tree.Kind.LET_DECLARATION)) {
            SyntaxToken token = ((VariableDeclarationTree)tree).token();
            this.highlight(this.offsets.startOffset(token), this.offsets.endOffset(token), "k");
        } else if (tree.is(Tree.Kind.TOKEN)) {
            this.highlightToken((InternalSyntaxToken)tree);
        } else if (tree.is(Tree.Kind.STRING_LITERAL)) {
            SyntaxToken token = ((LiteralTreeImpl)tree).token();
            this.highlight(this.offsets.startOffset(token), this.offsets.endOffset(token), "s");
        } else if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            SyntaxToken token = ((LiteralTreeImpl)tree).token();
            this.highlight(this.offsets.startOffset(token), this.offsets.endOffset(token), "c");
        }
    }

    private void highlightToken(InternalSyntaxToken token) {
        if (HighlighterVisitor.isKeyword(token.text())) {
            this.highlight(this.offsets.startOffset(token), this.offsets.endOffset(token), "k");
        }
        this.highlightComments(token);
    }

    private void highlightComments(InternalSyntaxToken token) {
        if (!token.trivias().isEmpty()) {
            for (SyntaxTrivia trivia : token.trivias()) {
                String code = trivia.text().startsWith("/**") ? "j" : "cd";
                this.highlight(this.offsets.startOffset(trivia), this.offsets.endOffset(trivia), code);
            }
        }
    }

    @Nullable
    private Highlightable.HighlightingBuilder initHighlighting(File file) {
        InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(file));
        if (inputFile == null) {
            throw new IllegalArgumentException("Cannot get " + Highlightable.class.getCanonicalName() + " for a null file");
        }
        Highlightable highlightable = (Highlightable)this.resourcePerspectives.as(Highlightable.class, (InputPath)inputFile);
        if (highlightable == null) {
            LOG.warn("Could not get " + Highlightable.class.getCanonicalName() + " for " + inputFile.file());
            return null;
        }
        this.highlighting = highlightable.newHighlighting();
        this.offsets = new SourceFileOffsets(file, this.fileSystem.encoding());
        return this.highlighting;
    }

    private void highlight(int startOffset, int endOffset, String code) {
        if (endOffset > startOffset) {
            this.highlighting.highlight(startOffset, endOffset, code);
        }
    }

    private static boolean isKeyword(String text) {
        for (String keyword : JavaScriptKeyword.keywordValues()) {
            if (!keyword.equals(text)) continue;
            return true;
        }
        return false;
    }
}

