/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.lexer.JavaScriptTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum JavaScriptLegacyGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    TEMPLATE_SPANS,
    TEMPLATE_CHARACTER,
    LINE_CONTINUATION,
    BACKTICK,
    DOLLAR_SIGN,
    BACKSLASH,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING_NO_LINE_BREAK_NOT_FOLLOWED_BY_LINE_BREAK,
    SPACING,
    SPACING_NOT_SKIPPED,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    PROPERTY_DEFINITION,
    PROPERTY_NAME,
    MEMBER_EXPRESSION,
    ARGUMENTS_LIST,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    EQUALITY_EXPRESSION,
    BITWISE_AND_EXPRESSION,
    BITWISE_XOR_EXPRESSION,
    BITWISE_OR_EXPRESSION,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_OR_EXPRESSION,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_LB,
    EXPRESSION_NO_IN,
    ARROW_FUNCTION,
    GENERATOR_EXPRESSION,
    ARRAY_LITERAL_ELEMENT,
    SPREAD_ELEMENT,
    ELEMENT_LIST,
    BINDING_REST_ELEMENT,
    SINGLE_NAME_BINDING,
    BINDING_ELEMENT,
    BINDING_PROPERTY,
    ARRAY_BINDING_PATTERN,
    BINDING_PATTERN,
    STATEMENT,
    VARIABLE_DECLARATION,
    INITIALISER,
    ITERATION_STATEMENT,
    OF,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    FINALLY,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER,
    LET,
    IDENTIFIER_REFERENCE,
    BINDING_IDENTIFIER,
    CLASS_ELEMENT,
    METHOD_DEFINITION,
    STATIC,
    GET,
    SET,
    MODULE_BODY,
    IMPORT_DECLARATION,
    EXPORT_DECLARATION,
    FROM,
    AS,
    SCRIPT,
    SCRIPT_BODY,
    SHEBANG,
    NEXT_NOT_LET,
    NEXT_NOT_LCURLY_AND_FUNCTION,
    NEXT_NOT_LCURLY,
    NEXT_NOT_LET_AND_BRACKET,
    NEXT_NOT_ES6_ASSIGNMENT_EXPRESSION,
    NEXT_NOT_FUNCTION_AND_CLASS;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return JavaScriptLegacyGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule((GrammarRuleKey)IDENTIFIER_NAME).is((Object)SPACING, new Object[]{b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        JavaScriptLegacyGrammar.lexical(b);
        b.setRootRule((GrammarRuleKey)SCRIPT);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING_NO_LINE_BREAK_NOT_FOLLOWED_BY_LINE_BREAK).is((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB});
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), new Object[]{b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), new Object[]{b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"))})}).skip();
        b.rule((GrammarRuleKey)SPACING_NOT_SKIPPED).is((Object)SPACING);
        b.rule((GrammarRuleKey)SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule((GrammarRuleKey)NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule((GrammarRuleKey)LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule((GrammarRuleKey)EOS).is(b.firstOf(b.sequence((Object)SPACING, (Object)JavaScriptPunctuator.SEMI), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOS_NO_LB).is(b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{JavaScriptPunctuator.SEMI}), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING_NO_LB, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)JavaScriptTokenType.IDENTIFIER).is((Object)SPACING, new Object[]{b.nextNot((Object)KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)JavaScriptTokenType.NUMERIC_LITERAL).is((Object)SPACING, new Object[]{b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)")});
        b.rule((GrammarRuleKey)STRING_LITERAL).is((Object)SPACING, new Object[]{b.token((TokenType)GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')"))});
        b.rule((GrammarRuleKey)JavaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is((Object)SPACING, new Object[]{b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+")});
        b.rule((GrammarRuleKey)TEMPLATE_CHARACTER).is(b.firstOf(b.sequence((Object)DOLLAR_SIGN, b.nextNot((Object)JavaScriptPunctuator.LCURLYBRACE)), b.sequence((Object)BACKSLASH, (Object)"\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}"), new Object[]{b.sequence((Object)BACKSLASH, (Object)BACKTICK), b.sequence((Object)BACKSLASH, (Object)DOLLAR_SIGN), LINE_CONTINUATION, b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"), b.regexp("[^`\\$\\n\\r\\u2028\\u2029]")}));
        b.rule((GrammarRuleKey)LINE_CONTINUATION).is((Object)BACKSLASH, new Object[]{LINE_TERMINATOR_SEQUENCE});
        b.rule((GrammarRuleKey)BACKSLASH).is(JavaScriptLegacyGrammar.character(b, "\\"));
        b.rule((GrammarRuleKey)BACKTICK).is(JavaScriptLegacyGrammar.character(b, "`"));
        b.rule((GrammarRuleKey)DOLLAR_SIGN).is(JavaScriptLegacyGrammar.character(b, "$"));
        b.rule((GrammarRuleKey)OF).is(JavaScriptLegacyGrammar.word(b, "of"));
        b.rule((GrammarRuleKey)FROM).is(JavaScriptLegacyGrammar.word(b, "from"));
        b.rule((GrammarRuleKey)AS).is(JavaScriptLegacyGrammar.word(b, "as"));
        b.rule((GrammarRuleKey)LET).is(JavaScriptLegacyGrammar.word(b, "let"));
        b.rule((GrammarRuleKey)STATIC).is(JavaScriptLegacyGrammar.word(b, "static"));
        b.rule((GrammarRuleKey)SET).is(JavaScriptLegacyGrammar.word(b, "set"));
        b.rule((GrammarRuleKey)GET).is(JavaScriptLegacyGrammar.word(b, "get"));
        b.rule((GrammarRuleKey)SHEBANG).is(b.regexp("#![^\\n\\r]*+"));
        b.rule((GrammarRuleKey)NEXT_NOT_LET_AND_BRACKET).is(b.nextNot((Object)LET, new Object[]{JavaScriptPunctuator.LBRACKET}));
        b.rule((GrammarRuleKey)NEXT_NOT_LET).is(b.nextNot((Object)LET));
        b.rule((GrammarRuleKey)NEXT_NOT_LCURLY_AND_FUNCTION).is(b.nextNot(b.firstOf((Object)JavaScriptPunctuator.LCURLYBRACE, (Object)JavaScriptKeyword.FUNCTION)));
        b.rule((GrammarRuleKey)NEXT_NOT_FUNCTION_AND_CLASS).is(b.nextNot((Object)JavaScriptKeyword.FUNCTION, new Object[]{JavaScriptKeyword.CLASS}));
        b.rule((GrammarRuleKey)NEXT_NOT_LCURLY).is(b.nextNot((Object)JavaScriptPunctuator.LCURLYBRACE));
        b.rule((GrammarRuleKey)NEXT_NOT_ES6_ASSIGNMENT_EXPRESSION).is(b.nextNot(b.regexp("(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]|//[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)*+"), new Object[]{"=>"}));
        JavaScriptLegacyGrammar.punctuators(b);
        JavaScriptLegacyGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.LCURLYBRACE, "{");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.RCURLYBRACE, "}");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.LPARENTHESIS, "(");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.RPARENTHESIS, ")");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.LBRACKET, "[");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.RBRACKET, "]");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.DOUBLEARROW, "=>");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.DOT, ".");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.ELLIPSIS, "...");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SEMI, ";");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.COMMA, ",");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.LT, "<", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.GT, ">", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.LE, "<=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.GE, ">=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.EQUAL, "==", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.NOTEQUAL, "!=", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.EQUAL2, "===");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.NOTEQUAL2, "!==");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"+", (Object)"=")));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.STAR, "*", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.MOD, "%", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.DIV, "/", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.INC, "++");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.DEC, "--");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf((Object)"<", (Object)"=")));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)">", (Object)"=")));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SR2, ">>>");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.AND, "&", b.nextNot((Object)"&", new Object[]{"="}));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.OR, "|", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.XOR, "^", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.BANG, "!", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.TILDA, "~");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.ANDAND, "&&");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.OROR, "||");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.QUERY, "?");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.COLON, ":");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.EQU, "=", b.nextNot((Object)"="));
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.PLUS_EQU, "+=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.MINUS_EQU, "-=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.DIV_EQU, "/=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.STAR_EQU, "*=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.MOD_EQU, "%=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SL_EQU, "<<=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SR_EQU, ">>=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.SR_EQU2, ">>>=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.AND_EQU, "&=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.OR_EQU, "|=");
        JavaScriptLegacyGrammar.punctuator(b, JavaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[JavaScriptKeyword.values().length - 2];
        for (int i = 0; i < JavaScriptKeyword.values().length; ++i) {
            JavaScriptKeyword tokenType = JavaScriptKeyword.values()[i];
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{tokenType.getValue(), b.nextNot((Object)LETTER_OR_DIGIT)});
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf((Object)JavaScriptKeyword.keywordValues()[0], (Object)JavaScriptKeyword.keywordValues()[1], rest), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (JavaScriptPunctuator tokenType : JavaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, b.token((TokenType)GenericTokenType.IDENTIFIER, (Object)value), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static Object character(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, (Object)value);
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (JavaScriptPunctuator tokenType : JavaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value, element});
            return;
        }
        throw new IllegalStateException(value);
    }

    private JavaScriptLegacyGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

