/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.symbols.type.PrimitiveType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

public class PrimitiveOperations {
    private static Map<OperationKey, Type> binaryOperationsResults = new HashMap<OperationKey, Type>();
    private static final Set<Tree.Kind> COMPARATIVE_OPERATORS;
    private static final Set<Tree.Kind> ARITHMETIC_OPERATORS;

    private PrimitiveOperations() {
    }

    static void put(Type.Kind leftOperandType, Type.Kind rightOperandType, Tree.Kind operation, Type result) {
        binaryOperationsResults.put(new OperationKey(leftOperandType, rightOperandType, operation), result);
    }

    static Type getType(ExpressionTree leftOperand, ExpressionTree rightOperand, Tree.Kind operationKind) {
        if (COMPARATIVE_OPERATORS.contains((Object)operationKind)) {
            return PrimitiveType.BOOLEAN;
        }
        if (ARITHMETIC_OPERATORS.contains((Object)operationKind)) {
            return PrimitiveType.NUMBER;
        }
        return PrimitiveOperations.getType(leftOperand.types().getUniqueKnownType(), rightOperand.types().getUniqueKnownType(), operationKind);
    }

    @Nullable
    static Type getType(@Nullable Type leftOperandType, @Nullable Type rightOperandType, Tree.Kind operationKind) {
        if (leftOperandType != null && rightOperandType != null) {
            return binaryOperationsResults.get(new OperationKey(leftOperandType.kind(), rightOperandType.kind(), operationKind));
        }
        return null;
    }

    static {
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.PLUS, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.NUMBER, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.STRING, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.CONDITIONAL_AND, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.CONDITIONAL_AND, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.BOOLEAN, Type.Kind.BOOLEAN, Tree.Kind.CONDITIONAL_AND, PrimitiveType.BOOLEAN);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.CONDITIONAL_OR, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.CONDITIONAL_OR, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.BOOLEAN, Type.Kind.BOOLEAN, Tree.Kind.CONDITIONAL_OR, PrimitiveType.BOOLEAN);
        COMPARATIVE_OPERATORS = ImmutableSet.of((Object)((Object)Tree.Kind.LESS_THAN), (Object)((Object)Tree.Kind.GREATER_THAN), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.EQUAL_TO), (Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object[])new Tree.Kind[]{Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO});
        ARITHMETIC_OPERATORS = ImmutableSet.of((Object)((Object)Tree.Kind.MINUS), (Object)((Object)Tree.Kind.MULTIPLY), (Object)((Object)Tree.Kind.DIVIDE), (Object)((Object)Tree.Kind.REMAINDER));
    }

    private static class OperationKey {
        Type.Kind leftOperandType;
        Type.Kind rightOperandType;
        Tree.Kind operation;

        public OperationKey(Type.Kind leftOperandType, Type.Kind rightOperandType, Tree.Kind operation) {
            this.leftOperandType = leftOperandType;
            this.rightOperandType = rightOperandType;
            this.operation = operation;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationKey that = (OperationKey)o;
            return this.leftOperandType == that.leftOperandType && this.rightOperandType == that.rightOperandType && this.operation == that.operation;
        }

        public int hashCode() {
            int result = this.leftOperandType.hashCode();
            result = 31 * result + this.rightOperandType.hashCode();
            result = 31 * result + this.operation.hashCode();
            return result;
        }
    }
}

