/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.tests;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.SymbolModelImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.api.CheckMessage;

public class TestCheckContext
implements TreeVisitorContext {
    private static final Logger LOG = LoggerFactory.getLogger(TestCheckContext.class);
    protected static final ActionParser<Tree> p = JavaScriptParserBuilder.createParser(Charsets.UTF_8);
    private final File file;
    private final ComplexityVisitor complexity;
    private final Settings settings;
    private ScriptTree tree;
    private SymbolModel symbolModel;
    List<CheckMessage> issues;

    public TestCheckContext(File file, Settings settings, JavaScriptCheck check) {
        block2: {
            this.tree = null;
            this.symbolModel = null;
            this.issues = new LinkedList<CheckMessage>();
            this.file = file;
            this.complexity = new ComplexityVisitor();
            this.settings = settings;
            try {
                this.tree = (ScriptTree)p.parse(file);
                this.symbolModel = SymbolModelImpl.create(this.tree, null, null);
            }
            catch (RecognitionException e) {
                LOG.error("Unable to parse file: " + file.getAbsolutePath());
                LOG.error(e.getMessage());
                if (!"ParsingErrorCheck".equals(check.getClass().getSimpleName())) break block2;
                this.addIssue(null, e.getLine(), e.getMessage());
            }
        }
    }

    @Override
    public ScriptTree getTopTree() {
        return this.tree;
    }

    @Override
    public void addIssue(JavaScriptCheck check, Tree tree, String message) {
        this.commonAddIssue(check, TestCheckContext.getLine(tree), message, -1.0);
    }

    @Override
    public void addIssue(JavaScriptCheck check, int line, String message) {
        this.commonAddIssue(check, line, message, -1.0);
    }

    @Override
    public void addFileIssue(JavaScriptCheck check, String message) {
        this.commonAddIssue(check, -1, message, -1.0);
    }

    @Override
    public void addIssue(JavaScriptCheck check, Tree tree, String message, double cost) {
        this.commonAddIssue(check, TestCheckContext.getLine(tree), message, cost);
    }

    @Override
    public void addIssue(JavaScriptCheck check, int line, String message, double cost) {
        this.commonAddIssue(check, line, message, cost);
    }

    @Override
    public void addIssue(JavaScriptCheck check, IssueLocation location, List<IssueLocation> secondaryLocations, Double cost) {
        throw new UnsupportedOperationException("To test rules which provide 'secondary locations' use JavaScriptCheckVerifier#verify()");
    }

    @Override
    public File getFile() {
        return this.file;
    }

    private void commonAddIssue(JavaScriptCheck check, int line, String message, double cost) {
        CheckMessage issue = new CheckMessage((Object)check, message, new Object[0]);
        if (cost >= 0.0) {
            issue.setCost(cost);
        }
        if (line > 0) {
            issue.setLine(line);
        }
        this.issues.add(issue);
    }

    private static int getLine(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }

    @Override
    public SymbolModel getSymbolModel() {
        return this.symbolModel;
    }

    @Override
    public String[] getPropertyValues(String name) {
        return this.settings.getStringArray(name);
    }

    @Override
    public int getComplexity(Tree tree) {
        return this.complexity.getComplexity(tree);
    }

    public List<CheckMessage> getIssues() {
        return this.issues;
    }
}

