/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.sonar.javascript.cfg.MutableBlock;

class BranchingBlock
extends MutableBlock {
    private MutableBlock trueSuccessor = null;
    private MutableBlock falseSuccessor = null;

    BranchingBlock() {
    }

    @Override
    public Set<MutableBlock> successors() {
        Preconditions.checkState((this.trueSuccessor != null ? 1 : 0) != 0, (Object)("Successors were not set on " + this));
        return ImmutableSet.of((Object)this.trueSuccessor, (Object)this.falseSuccessor);
    }

    public void setSuccessors(MutableBlock trueSuccessor, MutableBlock falseSuccessor) {
        Preconditions.checkArgument((trueSuccessor != null && falseSuccessor != null ? 1 : 0) != 0, (Object)"Successor cannot be null");
        Preconditions.checkArgument((!this.equals(trueSuccessor) && !this.equals(falseSuccessor) ? 1 : 0) != 0, (Object)"Cannot add itself as successor");
        this.trueSuccessor = trueSuccessor;
        this.falseSuccessor = falseSuccessor;
    }

    @Override
    public void replaceSuccessors(Map<MutableBlock, MutableBlock> replacements) {
        this.trueSuccessor = BranchingBlock.replacement(this.trueSuccessor, replacements);
        this.falseSuccessor = BranchingBlock.replacement(this.falseSuccessor, replacements);
    }

    @Override
    public MutableBlock trueSuccessor() {
        return this.trueSuccessor;
    }

    @Override
    public MutableBlock falseSuccessor() {
        return this.falseSuccessor;
    }
}

