/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.javascript.cfg.ControlFlowBlock;
import org.sonar.javascript.cfg.ControlFlowGraphBuilder;
import org.sonar.javascript.cfg.ControlFlowNode;
import org.sonar.javascript.cfg.MutableBlock;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;

public class ControlFlowGraph {
    private final ControlFlowNode start;
    private final ControlFlowNode end = new EndNode();
    private final ImmutableSet<ControlFlowBlock> blocks;
    private final ImmutableSetMultimap<ControlFlowNode, ControlFlowNode> predecessors;
    private final ImmutableSetMultimap<ControlFlowNode, ControlFlowNode> successors;
    private final ImmutableSetMultimap<ControlFlowNode, SyntaxToken> disconnectingJumps;
    private final ImmutableMap<StatementTree, ControlFlowBlock> startingBlocks;

    ControlFlowGraph(Set<MutableBlock> blocks, MutableBlock start, MutableBlock end, Map<StatementTree, MutableBlock> startingBlocks) {
        HashMap<MutableBlock, ControlFlowNode> immutableBlockByMutable = new HashMap<MutableBlock, ControlFlowNode>();
        ImmutableSet.Builder immutableBlockSetBuilder = ImmutableSet.builder();
        for (MutableBlock mutableBlock : blocks) {
            ImmutableBlock immutableBlock = new ImmutableBlock(mutableBlock.elements());
            immutableBlockByMutable.put(mutableBlock, immutableBlock);
            immutableBlockSetBuilder.add((Object)immutableBlock);
        }
        immutableBlockByMutable.put(end, this.end);
        ImmutableSetMultimap.Builder successorBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder predecessorBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder jumpBuilder = ImmutableSetMultimap.builder();
        for (MutableBlock mutableBlock : blocks) {
            ControlFlowNode immutableBlock = (ControlFlowNode)immutableBlockByMutable.get(mutableBlock);
            for (MutableBlock mutableBlockSuccessor : mutableBlock.successors()) {
                ControlFlowNode immutableBlockSuccessor = (ControlFlowNode)immutableBlockByMutable.get(mutableBlockSuccessor);
                predecessorBuilder.put((Object)immutableBlockSuccessor, (Object)immutableBlock);
                successorBuilder.put((Object)immutableBlock, (Object)immutableBlockSuccessor);
            }
            jumpBuilder.putAll((Object)immutableBlock, mutableBlock.disconnectingJumps());
        }
        ImmutableMap.Builder startingBlockBuilder = ImmutableMap.builder();
        for (Map.Entry<StatementTree, MutableBlock> entry : startingBlocks.entrySet()) {
            ControlFlowBlock block = (ControlFlowBlock)immutableBlockByMutable.get(entry.getValue());
            startingBlockBuilder.put((Object)entry.getKey(), (Object)block);
        }
        this.start = blocks.isEmpty() ? this.end : (ControlFlowNode)immutableBlockByMutable.get(start);
        this.blocks = immutableBlockSetBuilder.build();
        this.predecessors = predecessorBuilder.build();
        this.successors = successorBuilder.build();
        this.disconnectingJumps = jumpBuilder.build();
        this.startingBlocks = startingBlockBuilder.build();
    }

    public static ControlFlowGraph build(ScriptTree tree) {
        return new ControlFlowGraphBuilder().createGraph(tree);
    }

    public static ControlFlowGraph build(BlockTree body) {
        return new ControlFlowGraphBuilder().createGraph(body);
    }

    public ControlFlowNode start() {
        return this.start;
    }

    public ControlFlowNode end() {
        return this.end;
    }

    public Set<ControlFlowBlock> blocks() {
        return this.blocks;
    }

    public Set<ControlFlowBlock> unreachableBlocks() {
        HashSet<ControlFlowBlock> unreachable = new HashSet<ControlFlowBlock>();
        for (ControlFlowBlock block : this.blocks) {
            if (block.equals(this.start) || !block.predecessors().isEmpty()) continue;
            unreachable.add(block);
        }
        return unreachable;
    }

    public Set<SyntaxToken> disconnectingJumps(ControlFlowBlock block) {
        return this.disconnectingJumps.get((Object)block);
    }

    public ControlFlowBlock getStartingBlock(StatementTree nonEmptyStatementTree) {
        return (ControlFlowBlock)this.startingBlocks.get((Object)nonEmptyStatementTree);
    }

    private class EndNode
    implements ControlFlowNode {
        private EndNode() {
        }

        @Override
        public Set<ControlFlowNode> predecessors() {
            return ControlFlowGraph.this.predecessors.get((Object)this);
        }

        @Override
        public Set<ControlFlowNode> successors() {
            return ImmutableSet.of();
        }

        public String toString() {
            return "End";
        }
    }

    private class ImmutableBlock
    implements ControlFlowBlock {
        private final List<Tree> elements;

        public ImmutableBlock(List<Tree> elements) {
            Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Cannot build block without any element");
            this.elements = elements;
        }

        @Override
        public Set<ControlFlowNode> predecessors() {
            return ControlFlowGraph.this.predecessors.get((Object)this);
        }

        @Override
        public Set<ControlFlowNode> successors() {
            return ControlFlowGraph.this.successors.get((Object)this);
        }

        @Override
        public List<Tree> elements() {
            return this.elements;
        }
    }
}

