/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.javascript.cfg.BranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.cfg.EndBlock;
import org.sonar.javascript.cfg.ForwardingBlock;
import org.sonar.javascript.cfg.MutableBlock;
import org.sonar.javascript.cfg.SimpleBlock;
import org.sonar.javascript.cfg.SingleSuccessorBlock;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ComputedPropertyNameTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.TaggedTemplateTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DebuggerStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;

class ControlFlowGraphBuilder {
    private final Set<MutableBlock> blocks = new HashSet<MutableBlock>();
    private final EndBlock end = new EndBlock();
    private MutableBlock currentBlock = this.createSimpleBlock(this.end);
    private MutableBlock start;
    private final Map<StatementTree, MutableBlock> startingBlockByStatement = new HashMap<StatementTree, MutableBlock>();
    private final Deque<Breakable> breakables = new ArrayDeque<Breakable>();
    private final Deque<MutableBlock> throwTargets = new ArrayDeque<MutableBlock>();
    private String currentLabel = null;
    private static final Tree.Kind[] SIMPLE_BINARY_KINDS = new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.RELATIONAL_IN, Tree.Kind.INSTANCE_OF, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_XOR, Tree.Kind.BITWISE_OR, Tree.Kind.COMMA_OPERATOR};
    private static final Tree.Kind[] ASSIGNMENT_KINDS = new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};
    private static final Tree.Kind[] UNARY_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.DELETE, Tree.Kind.VOID, Tree.Kind.TYPEOF, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT};

    ControlFlowGraphBuilder() {
    }

    public ControlFlowGraph createGraph(ScriptTree tree) {
        Object items = ImmutableList.of();
        if (tree.items() != null) {
            items = tree.items().items();
        }
        return this.createGraph((List<? extends Tree>)items);
    }

    public ControlFlowGraph createGraph(BlockTree body) {
        return this.createGraph(body.statements());
    }

    private ControlFlowGraph createGraph(List<? extends Tree> items) {
        this.throwTargets.push(this.end);
        this.build(items);
        this.start = this.currentBlock;
        this.removeEmptyBlocks();
        return new ControlFlowGraph(this.blocks, this.start, this.end, this.startingBlockByStatement);
    }

    private void removeEmptyBlocks() {
        HashMap<MutableBlock, MutableBlock> emptyBlockReplacements = new HashMap<MutableBlock, MutableBlock>();
        for (SingleSuccessorBlock singleSuccessorBlock : Iterables.filter(this.blocks, SingleSuccessorBlock.class)) {
            if (!singleSuccessorBlock.isEmpty()) continue;
            MutableBlock firstNonEmptySuccessor = singleSuccessorBlock.skipEmptyBlocks();
            emptyBlockReplacements.put(singleSuccessorBlock, firstNonEmptySuccessor);
            for (SyntaxToken jump : singleSuccessorBlock.disconnectingJumps()) {
                firstNonEmptySuccessor.addDisconnectingJump(jump);
            }
        }
        this.blocks.removeAll(emptyBlockReplacements.keySet());
        for (MutableBlock mutableBlock : this.blocks) {
            mutableBlock.replaceSuccessors(emptyBlockReplacements);
        }
        if (emptyBlockReplacements.containsKey(this.start)) {
            this.start = (MutableBlock)emptyBlockReplacements.get(this.start);
        }
        for (Map.Entry entry : this.startingBlockByStatement.entrySet()) {
            MutableBlock block = (MutableBlock)entry.getValue();
            if (!emptyBlockReplacements.containsKey(block)) continue;
            this.startingBlockByStatement.put((StatementTree)entry.getKey(), (MutableBlock)emptyBlockReplacements.get(block));
        }
    }

    private void build(List<? extends Tree> trees) {
        for (Tree tree : Lists.reverse(trees)) {
            this.build(tree);
        }
    }

    private void build(Tree tree) {
        if (tree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            this.buildExpression(((ExpressionStatementTree)tree).expression());
            this.markStatementStartingBlock((StatementTree)tree);
        } else if (tree.is(Tree.Kind.VARIABLE_STATEMENT)) {
            this.buildExpression(((VariableStatementTree)tree).declaration());
            this.markStatementStartingBlock((StatementTree)tree);
        } else if (tree.is(Tree.Kind.IF_STATEMENT)) {
            this.visitIfStatement((IfStatementTree)tree);
        } else if (tree.is(Tree.Kind.FOR_STATEMENT)) {
            this.visitForStatement((ForStatementTree)tree);
        } else if (tree.is(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT)) {
            this.visitForObjectStatement((ForObjectStatementTree)tree);
        } else if (tree.is(Tree.Kind.WHILE_STATEMENT)) {
            this.visitWhileStatement((WhileStatementTree)tree);
        } else if (tree.is(Tree.Kind.DO_WHILE_STATEMENT)) {
            this.visitDoWhileStatement((DoWhileStatementTree)tree);
        } else if (tree.is(Tree.Kind.CONTINUE_STATEMENT)) {
            this.visitContinueStatement((ContinueStatementTree)tree);
        } else if (tree.is(Tree.Kind.BREAK_STATEMENT)) {
            this.visitBreakStatement((BreakStatementTree)tree);
        } else if (tree.is(Tree.Kind.RETURN_STATEMENT)) {
            this.visitReturnStatement((ReturnStatementTree)tree);
        } else if (tree.is(Tree.Kind.BLOCK)) {
            this.visitBlock((BlockTree)tree);
        } else if (tree.is(Tree.Kind.LABELLED_STATEMENT)) {
            this.visitLabelledStatement((LabelledStatementTree)tree);
        } else if (tree.is(Tree.Kind.TRY_STATEMENT)) {
            this.visitTryStatement((TryStatementTree)tree);
        } else if (tree.is(Tree.Kind.THROW_STATEMENT)) {
            this.visitThrowStatement((ThrowStatementTree)tree);
        } else if (tree.is(Tree.Kind.SWITCH_STATEMENT)) {
            this.visitSwitchStatement((SwitchStatementTree)tree);
        } else if (tree.is(Tree.Kind.WITH_STATEMENT)) {
            WithStatementTree with = (WithStatementTree)tree;
            this.build(with.statement());
            this.currentBlock.addElement(with.expression());
            this.markStatementStartingBlock(with);
        } else if (tree.is(Tree.Kind.DEBUGGER_STATEMENT)) {
            this.currentBlock.addElement(tree);
            this.markStatementStartingBlock((DebuggerStatementTree)tree);
        } else if (tree.is(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.CLASS_DECLARATION, Tree.Kind.IMPORT_DECLARATION, Tree.Kind.IMPORT_MODULE_DECLARATION, Tree.Kind.DEFAULT_EXPORT_DECLARATION, Tree.Kind.NAMED_EXPORT_DECLARATION, Tree.Kind.NAMESPACE_EXPORT_DECLARATION)) {
            this.currentBlock.addElement(tree);
        } else if (!tree.is(Tree.Kind.EMPTY_STATEMENT)) {
            throw new IllegalArgumentException("Cannot build CFG for " + tree);
        }
    }

    private void markStatementStartingBlock(StatementTree tree) {
        this.startingBlockByStatement.put(tree, this.currentBlock);
    }

    private void buildExpressions(List<? extends Tree> expressions) {
        for (Tree expression : Lists.reverse(expressions)) {
            this.buildExpression(expression);
        }
    }

    private void buildExpression(Tree tree) {
        this.currentBlock.addElement(tree);
        if (tree.is(SIMPLE_BINARY_KINDS)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            this.buildExpression(binary.rightOperand());
            this.buildExpression(binary.leftOperand());
        } else if (tree.is(ASSIGNMENT_KINDS)) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
            this.buildExpression(assignment.variable());
            this.buildExpression(assignment.expression());
        } else if (tree.is(UNARY_KINDS)) {
            UnaryExpressionTree unary = (UnaryExpressionTree)tree;
            this.buildExpression(unary.expression());
        } else if (tree.is(Tree.Kind.ARRAY_LITERAL)) {
            ArrayLiteralTree arrayLiteral = (ArrayLiteralTree)tree;
            this.buildExpressions(arrayLiteral.elements());
        } else if (tree.is(Tree.Kind.OBJECT_LITERAL)) {
            ObjectLiteralTree objectLiteral = (ObjectLiteralTree)tree;
            this.buildExpressions(objectLiteral.properties());
        } else if (tree.is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            MemberExpressionTree memberExpression = (MemberExpressionTree)tree;
            this.buildExpression(memberExpression.object());
        } else if (tree.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION)) {
            MemberExpressionTree memberExpression = (MemberExpressionTree)tree;
            this.buildExpression(memberExpression.property());
            this.buildExpression(memberExpression.object());
        } else if (tree.is(Tree.Kind.CALL_EXPRESSION)) {
            CallExpressionTree callExpression = (CallExpressionTree)tree;
            this.buildExpressions(callExpression.arguments().parameters());
            this.buildExpression(callExpression.callee());
        } else if (tree.is(Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION)) {
            VariableDeclarationTree declaration = (VariableDeclarationTree)tree;
            this.buildExpressions(declaration.variables());
        } else if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
            InitializedBindingElementTree initializedBindingElementTree = (InitializedBindingElementTree)tree;
            this.buildExpression(initializedBindingElementTree.left());
            this.buildExpression(initializedBindingElementTree.right());
        } else if (tree.is(Tree.Kind.PAIR_PROPERTY)) {
            PairPropertyTree pairProperty = (PairPropertyTree)tree;
            this.buildExpression(pairProperty.value());
            this.buildExpression(pairProperty.key());
        } else if (tree.is(Tree.Kind.COMPUTED_PROPERTY_NAME)) {
            ComputedPropertyNameTree computedPropertyName = (ComputedPropertyNameTree)tree;
            this.buildExpression(computedPropertyName.expression());
        } else if (tree.is(Tree.Kind.NEW_EXPRESSION)) {
            NewExpressionTree newExpression = (NewExpressionTree)tree;
            if (newExpression.arguments() != null) {
                this.buildExpressions(newExpression.arguments().parameters());
            }
            this.buildExpression(newExpression.expression());
        } else if (tree.is(Tree.Kind.CONDITIONAL_AND)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            this.buildExpression(binary.rightOperand());
            this.currentBlock = this.createBranchingBlock(this.currentBlock, this.currentBlock.falseSuccessor());
            this.buildExpression(binary.leftOperand());
        } else if (tree.is(Tree.Kind.CONDITIONAL_OR)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            this.buildExpression(binary.rightOperand());
            this.currentBlock = this.createBranchingBlock(this.currentBlock, this.currentBlock.trueSuccessor());
            this.buildExpression(binary.leftOperand());
        } else if (tree.is(Tree.Kind.CONDITIONAL_EXPRESSION)) {
            ConditionalExpressionTree conditionalExpression = (ConditionalExpressionTree)tree;
            MutableBlock successor = this.currentBlock;
            this.currentBlock = this.createSimpleBlock(successor);
            this.buildExpression(conditionalExpression.falseExpression());
            MutableBlock falseBlock = this.currentBlock;
            this.currentBlock = this.createSimpleBlock(successor);
            this.buildExpression(conditionalExpression.trueExpression());
            MutableBlock trueBlock = this.currentBlock;
            this.currentBlock = this.createBranchingBlock(trueBlock, falseBlock);
            this.buildExpression(conditionalExpression.condition());
        } else if (tree.is(Tree.Kind.REST_ELEMENT)) {
            RestElementTree restElement = (RestElementTree)tree;
            this.buildExpression(restElement.element());
        } else if (tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            ParenthesisedExpressionTree parenthesisedExpression = (ParenthesisedExpressionTree)tree;
            this.buildExpression(parenthesisedExpression.expression());
        } else if (tree.is(Tree.Kind.TEMPLATE_LITERAL)) {
            TemplateLiteralTree templateLiteral = (TemplateLiteralTree)tree;
            this.buildExpressions(templateLiteral.expressions());
        } else if (tree.is(Tree.Kind.TEMPLATE_EXPRESSION)) {
            TemplateExpressionTree templateExpression = (TemplateExpressionTree)tree;
            this.buildExpression(templateExpression.expression());
        } else if (tree.is(Tree.Kind.TAGGED_TEMPLATE)) {
            TaggedTemplateTree taggedTemplate = (TaggedTemplateTree)tree;
            this.buildExpression(taggedTemplate.template());
            this.buildExpression(taggedTemplate.callee());
        } else if (tree.is(Tree.Kind.YIELD_EXPRESSION)) {
            YieldExpressionTree yieldExpression = (YieldExpressionTree)tree;
            this.buildExpression(yieldExpression.argument());
        }
    }

    private void visitBlock(BlockTree block) {
        boolean hasLabel;
        boolean bl = hasLabel = this.currentLabel != null;
        if (hasLabel) {
            this.addBreakable(this.currentBlock, null);
            this.currentBlock = this.createSimpleBlock(this.currentBlock);
        }
        this.build(block.statements());
        if (hasLabel) {
            this.removeBreakable();
        }
    }

    private void addBreakable(MutableBlock breakTarget, MutableBlock continueTarget) {
        String label = null;
        if (this.currentLabel != null) {
            label = this.currentLabel;
            this.currentLabel = null;
        }
        this.breakables.addFirst(new Breakable(continueTarget, breakTarget, label));
    }

    private void removeBreakable() {
        this.breakables.removeFirst();
    }

    private void visitReturnStatement(ReturnStatementTree tree) {
        this.currentBlock.addDisconnectingJump(tree.returnKeyword());
        this.currentBlock = this.createSimpleBlock(tree, this.end);
        if (tree.expression() != null) {
            this.buildExpression(tree.expression());
        }
        this.markStatementStartingBlock(tree);
    }

    private void visitContinueStatement(ContinueStatementTree tree) {
        MutableBlock target = null;
        String label = tree.label() == null ? null : tree.label().name();
        for (Breakable breakable : this.breakables) {
            if (breakable.continueTarget == null || label != null && !label.equals(breakable.label)) continue;
            target = breakable.continueTarget;
            break;
        }
        Preconditions.checkState((target != null ? 1 : 0) != 0, (Object)("No continue target can be found for label " + label));
        this.currentBlock.addDisconnectingJump(tree.continueKeyword());
        this.currentBlock = this.createSimpleBlock(tree, target);
        this.markStatementStartingBlock(tree);
    }

    private void visitBreakStatement(BreakStatementTree tree) {
        MutableBlock target = null;
        String label = tree.label() == null ? null : tree.label().name();
        for (Breakable breakable : this.breakables) {
            if (label != null && !label.equals(breakable.label)) continue;
            target = breakable.breakTarget;
            break;
        }
        Preconditions.checkState((target != null ? 1 : 0) != 0, (Object)("No break target can be found for label " + label));
        this.currentBlock.addDisconnectingJump(tree.breakKeyword());
        this.currentBlock = this.createSimpleBlock(tree, target);
        this.markStatementStartingBlock(tree);
    }

    private void visitIfStatement(IfStatementTree tree) {
        MutableBlock successor = this.currentBlock;
        if (tree.elseClause() != null) {
            this.buildSubFlow(tree.elseClause().statement(), successor);
        }
        MutableBlock elseBlock = this.currentBlock;
        this.buildSubFlow(tree.statement(), successor);
        MutableBlock thenBlock = this.currentBlock;
        BranchingBlock branchingBlock = this.createBranchingBlock(thenBlock, elseBlock);
        this.currentBlock = branchingBlock;
        this.buildExpression(tree.condition());
        this.markStatementStartingBlock(tree);
    }

    private void visitForStatement(ForStatementTree tree) {
        MutableBlock forStatementSuccessor = this.currentBlock;
        ForwardingBlock linkToCondition = this.createForwardingBlock();
        ForwardingBlock linkToUpdate = this.createForwardingBlock();
        MutableBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToUpdate, this.currentBlock);
        if (tree.update() != null) {
            this.currentBlock = this.createSimpleBlock(linkToCondition);
            this.buildExpression(tree.update());
            linkToUpdate.setSuccessor(this.currentBlock);
        } else {
            linkToUpdate.setSuccessor(linkToCondition);
        }
        if (tree.condition() != null) {
            this.currentBlock = this.createBranchingBlock(loopBodyBlock, forStatementSuccessor);
            this.buildExpression(tree.condition());
            linkToCondition.setSuccessor(this.currentBlock);
        } else {
            linkToCondition.setSuccessor(loopBodyBlock);
        }
        this.markStatementStartingBlock(tree);
        this.currentBlock = this.createSimpleBlock(linkToCondition);
        if (tree.init() != null) {
            this.buildExpression(tree.init());
        } else if (tree.condition() == null && loopBodyBlock.isEmpty()) {
            loopBodyBlock.addElement(tree.forKeyword());
        }
    }

    private void visitForObjectStatement(ForObjectStatementTree tree) {
        MutableBlock successor = this.currentBlock;
        ForwardingBlock linkToAssignment = this.createForwardingBlock();
        MutableBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToAssignment, this.currentBlock);
        BranchingBlock assignmentBlock = this.createBranchingBlock(loopBodyBlock, successor);
        this.currentBlock = assignmentBlock;
        this.buildExpression(tree.variableOrExpression());
        this.buildExpression(tree.expression());
        linkToAssignment.setSuccessor(this.currentBlock);
        this.markStatementStartingBlock(tree);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
    }

    private void visitWhileStatement(WhileStatementTree tree) {
        MutableBlock successor = this.currentBlock;
        ForwardingBlock linkToCondition = this.createForwardingBlock();
        MutableBlock loopBodyBlock = this.buildLoopBody(tree.statement(), linkToCondition, successor);
        this.currentBlock = this.createBranchingBlock(loopBodyBlock, successor);
        this.buildExpression(tree.condition());
        linkToCondition.setSuccessor(this.currentBlock);
        this.markStatementStartingBlock(tree);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
    }

    private void visitDoWhileStatement(DoWhileStatementTree tree) {
        MutableBlock successor = this.currentBlock;
        ForwardingBlock linkToBody = this.createForwardingBlock();
        this.currentBlock = this.createBranchingBlock(linkToBody, successor);
        this.buildExpression(tree.condition());
        MutableBlock loopBodyBlock = this.buildLoopBody(tree.statement(), this.currentBlock, successor);
        linkToBody.setSuccessor(loopBodyBlock);
        this.markStatementStartingBlock(tree);
        this.currentBlock = this.createSimpleBlock(loopBodyBlock);
    }

    private void visitLabelledStatement(LabelledStatementTree tree) {
        this.currentLabel = tree.label().name();
        this.build(tree.statement());
        StatementTree firstStatement = tree.statement();
        if (firstStatement.is(Tree.Kind.BLOCK)) {
            BlockTree block = (BlockTree)firstStatement;
            if (block.statements().isEmpty()) {
                this.markStatementStartingBlock(tree);
                return;
            }
            firstStatement = block.statements().get(0);
        }
        this.startingBlockByStatement.put(tree, this.startingBlockByStatement.get(firstStatement));
    }

    private void visitTryStatement(TryStatementTree tree) {
        MutableBlock catchOrFinallyBlock = null;
        if (tree.finallyBlock() != null) {
            this.currentBlock = this.createSimpleBlock(this.currentBlock);
            this.build(tree.finallyBlock());
            this.throwTargets.push(this.currentBlock);
            catchOrFinallyBlock = this.currentBlock;
        }
        if (tree.catchBlock() != null) {
            MutableBlock catchSuccessor = this.currentBlock;
            this.buildSubFlow(tree.catchBlock().block(), this.currentBlock);
            BranchingBlock catchBlock = this.createBranchingBlock(this.currentBlock, catchSuccessor);
            this.currentBlock = catchBlock;
            this.buildExpression(tree.catchBlock().parameter());
            catchOrFinallyBlock = catchBlock;
            this.currentBlock = catchBlock;
        }
        if (tree.finallyBlock() != null) {
            this.throwTargets.pop();
        }
        this.throwTargets.push(this.currentBlock);
        this.currentBlock = this.createSimpleBlock(this.currentBlock);
        this.build(tree.block());
        this.throwTargets.pop();
        this.currentBlock = this.createBranchingBlock(this.currentBlock, catchOrFinallyBlock);
        this.currentBlock.addElement(tree.tryKeyword());
        this.markStatementStartingBlock(tree);
    }

    private void visitThrowStatement(ThrowStatementTree tree) {
        this.currentBlock.addDisconnectingJump(tree.throwKeyword());
        this.currentBlock = this.createSimpleBlock(this.throwTargets.peek());
        this.buildExpression(tree.expression());
        this.markStatementStartingBlock(tree);
    }

    private void visitSwitchStatement(SwitchStatementTree tree) {
        this.addBreakable(this.currentBlock, null);
        MutableBlock nextStatementBlock = this.currentBlock;
        ForwardingBlock defaultForwardingBlock = this.createForwardingBlock();
        defaultForwardingBlock.setSuccessor(this.currentBlock);
        MutableBlock nextCase = defaultForwardingBlock;
        for (SwitchClauseTree switchCaseClause : Lists.reverse(tree.cases())) {
            if (switchCaseClause.is(Tree.Kind.CASE_CLAUSE)) {
                this.currentBlock = this.createSimpleBlock(nextStatementBlock);
                this.build(switchCaseClause.statements());
                if (!switchCaseClause.statements().isEmpty()) {
                    nextStatementBlock = this.currentBlock;
                }
                CaseClauseTree caseClause = (CaseClauseTree)switchCaseClause;
                this.currentBlock = this.createBranchingBlock(nextStatementBlock, nextCase);
                this.buildExpression(caseClause.expression());
                nextCase = this.currentBlock;
                continue;
            }
            this.currentBlock = this.createSimpleBlock(nextStatementBlock);
            this.build(switchCaseClause.statements());
            defaultForwardingBlock.setSuccessor(this.currentBlock);
            if (switchCaseClause.statements().isEmpty()) continue;
            nextStatementBlock = this.currentBlock;
        }
        this.removeBreakable();
        this.currentBlock = this.createSimpleBlock(nextCase);
        this.buildExpression(tree.expression());
        this.markStatementStartingBlock(tree);
    }

    private MutableBlock buildLoopBody(StatementTree body, MutableBlock conditionBlock, MutableBlock breakTarget) {
        this.addBreakable(breakTarget, conditionBlock);
        this.currentLabel = null;
        this.buildSubFlow(body, conditionBlock);
        MutableBlock loopBodyBlock = this.currentBlock;
        this.removeBreakable();
        return loopBodyBlock;
    }

    private void buildSubFlow(StatementTree subFlowTree, MutableBlock successor) {
        this.currentBlock = this.createSimpleBlock(successor);
        this.build(subFlowTree);
    }

    private BranchingBlock createBranchingBlock(MutableBlock trueSuccessor, MutableBlock falseSuccessor) {
        BranchingBlock block = new BranchingBlock();
        block.setSuccessors(trueSuccessor, falseSuccessor);
        this.blocks.add(block);
        return block;
    }

    private SimpleBlock createSimpleBlock(Tree element, MutableBlock successor) {
        SimpleBlock block = this.createSimpleBlock(successor);
        block.addElement(element);
        return block;
    }

    private SimpleBlock createSimpleBlock(MutableBlock successor) {
        SimpleBlock block = new SimpleBlock(successor);
        this.blocks.add(block);
        return block;
    }

    private ForwardingBlock createForwardingBlock() {
        ForwardingBlock block = new ForwardingBlock();
        this.blocks.add(block);
        return block;
    }

    private static class Breakable {
        final MutableBlock continueTarget;
        final MutableBlock breakTarget;
        final String label;

        public Breakable(MutableBlock continueTarget, MutableBlock breakTarget, String label) {
            this.continueTarget = continueTarget;
            this.breakTarget = breakTarget;
            this.label = label;
        }
    }
}

