/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

abstract class MutableBlock {
    private final List<Tree> elements = new ArrayList<Tree>();
    private final Set<SyntaxToken> disconnectingJumps = new HashSet<SyntaxToken>();

    MutableBlock() {
    }

    public abstract Set<MutableBlock> successors();

    public abstract void replaceSuccessors(Map<MutableBlock, MutableBlock> var1);

    public abstract MutableBlock trueSuccessor();

    public abstract MutableBlock falseSuccessor();

    public List<Tree> elements() {
        return Lists.reverse(this.elements);
    }

    public void addElement(Tree element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"Cannot add a null element to a block");
        this.elements.add(element);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    static MutableBlock replacement(MutableBlock successor, Map<MutableBlock, MutableBlock> replacements) {
        MutableBlock newSuccessor = replacements.get(successor);
        return newSuccessor == null ? successor : newSuccessor;
    }

    public Set<SyntaxToken> disconnectingJumps() {
        return this.disconnectingJumps;
    }

    public void addDisconnectingJump(SyntaxToken jumpToken) {
        this.disconnectingJumps.add(jumpToken);
    }
}

