/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ObjectBindingPatternTreeImpl
extends JavaScriptTree
implements ObjectBindingPatternTree {
    private SyntaxToken openCurlyBrace;
    private SeparatedList<Tree> bindingElements;
    private SyntaxToken closeCurlyBrace;

    public ObjectBindingPatternTreeImpl(SeparatedList<Tree> bindingElements) {
        this.bindingElements = bindingElements;
    }

    public ObjectBindingPatternTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.bindingElements = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.closeCurlyBrace = closeCurlyBrace;
    }

    public ObjectBindingPatternTreeImpl complete(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        return this;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<Tree> elements() {
        return this.bindingElements;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_BINDING_PATTERN;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.bindingElements.elementsAndSeparators((Function<Tree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitObjectBindingPattern(this);
    }

    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        for (Tree element : this.bindingElements) {
            if (element.is(Tree.Kind.BINDING_PROPERTY)) {
                bindingIdentifiers.addAll(this.identifierFromBindingElement(((BindingPropertyTree)element).value()));
                continue;
            }
            if (element.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                bindingIdentifiers.addAll(this.identifierFromBindingElement(((InitializedBindingElementTree)element).left()));
                continue;
            }
            bindingIdentifiers.addAll(this.identifierFromBindingElement((BindingElementTree)element));
        }
        return bindingIdentifiers;
    }

    private List<IdentifierTree> identifierFromBindingElement(BindingElementTree bindingElement) {
        ArrayList bindingIdentifiers = Lists.newArrayList();
        if (bindingElement.is(Tree.Kind.BINDING_IDENTIFIER)) {
            bindingIdentifiers.add((IdentifierTree)bindingElement);
        } else if (bindingElement.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            bindingIdentifiers.addAll(((ObjectBindingPatternTreeImpl)bindingElement).bindingIdentifiers());
        } else {
            bindingIdentifiers.addAll(((ArrayBindingPatternTreeImpl)bindingElement).bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

