/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.declaration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ParameterListTreeImpl
extends JavaScriptTree
implements ParameterListTree {
    private InternalSyntaxToken openParenthesis;
    private final SeparatedList<Tree> parameters;
    private InternalSyntaxToken closeParenthesis;
    private final Tree.Kind kind;

    public ParameterListTreeImpl(Tree.Kind kind, SeparatedList<Tree> parameters) {
        Preconditions.checkArgument((parameters.size() == parameters.getSeparators().size() + 1 ? 1 : 0) != 0);
        this.kind = kind;
        this.parameters = parameters;
    }

    public ParameterListTreeImpl(Tree.Kind kind, InternalSyntaxToken openParenthesis, InternalSyntaxToken closeParenthesis) {
        this.kind = kind;
        this.openParenthesis = openParenthesis;
        this.parameters = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.closeParenthesis = closeParenthesis;
    }

    public ParameterListTreeImpl complete(InternalSyntaxToken openParenthesis, InternalSyntaxToken closeParenthesis) {
        this.openParenthesis = openParenthesis;
        this.closeParenthesis = closeParenthesis;
        return this;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public SeparatedList<Tree> parameters() {
        return this.parameters;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openParenthesis), this.parameters.elementsAndSeparators((Function<Tree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeParenthesis));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitParameterList(this);
    }

    public List<IdentifierTree> parameterIdentifiers() {
        if (this.kind != Tree.Kind.FORMAL_PARAMETER_LIST) {
            throw new IllegalStateException("ParameterListTreeImpl#parameterIdentifiers() can be called for Tree.Kind.FORMAL_PARAMETER_LIST only.");
        }
        ArrayList identifiers = Lists.newArrayList();
        for (Tree parameter : this.parameters) {
            if (parameter.is(Tree.Kind.BINDING_IDENTIFIER)) {
                identifiers.add((IdentifierTree)parameter);
                continue;
            }
            if (parameter.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                identifiers.addAll(((InitializedBindingElementTreeImpl)parameter).bindingIdentifiers());
                continue;
            }
            if (parameter.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
                identifiers.addAll(((ObjectBindingPatternTreeImpl)parameter).bindingIdentifiers());
                continue;
            }
            if (parameter.is(Tree.Kind.REST_ELEMENT)) {
                identifiers.add((IdentifierTree)((RestElementTree)parameter).element());
                continue;
            }
            identifiers.addAll(((ArrayBindingPatternTreeImpl)parameter).bindingIdentifiers());
        }
        return identifiers;
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

