/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.sonar.sslr.api.typed.Optional;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.expression.SuperTreeImpl;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FromClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportModuleDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NamedExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ComputedPropertyNameTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.TaggedTemplateTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DebuggerStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.EmptyStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

@Beta
public abstract class DoubleDispatchVisitor
implements TreeVisitor {
    private TreeVisitorContext context = null;

    @Override
    public TreeVisitorContext getContext() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"this#scanTree(context) should be called to initialised the context before accessing it");
        return this.context;
    }

    @Override
    public final void scanTree(TreeVisitorContext context) {
        this.context = context;
        this.scan(context.getTopTree());
    }

    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected <T> void scan(List<T> trees) {
        for (T tree : trees) {
            if (tree instanceof Optional) {
                this.scan((Optional<Tree>)((Optional)tree));
                continue;
            }
            if (tree instanceof Tree) {
                this.scan((Tree)tree);
                continue;
            }
            throw new IllegalArgumentException("List element type should be of type Optional or Tree.");
        }
    }

    private void scan(Optional<Tree> tree) {
        if (tree.isPresent()) {
            this.scan((Tree)tree.get());
        }
    }

    public void visitScript(ScriptTree tree) {
        this.scan(tree.items());
    }

    public void visitModule(ModuleTree tree) {
        this.scan(tree.items());
    }

    public void visitImportDeclaration(ImportDeclarationTree tree) {
        this.scan(tree.importClause());
        this.scan(tree.fromClause());
    }

    public void visitImportModuleDeclaration(ImportModuleDeclarationTree tree) {
        this.scan(tree.moduleName());
    }

    public void visitImportClause(ImportClauseTree tree) {
        this.scan(tree.namedImport());
    }

    public void visitSpecifierList(SpecifierListTree tree) {
        this.scan(tree.specifiers());
    }

    public void visitSpecifier(SpecifierTree tree) {
        this.scan(tree.name());
        this.scan(tree.localName());
    }

    public void visitFromClause(FromClauseTree tree) {
        this.scan(tree.module());
    }

    public void visitDefaultExportDeclaration(DefaultExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    public void visitNameSpaceExportDeclaration(NameSpaceExportDeclarationTree tree) {
        this.scan(tree.fromClause());
    }

    public void visitNamedExportDeclaration(NamedExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    public void visitVariableStatement(VariableStatementTree tree) {
        this.scan(tree.declaration());
    }

    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.scan(tree.variables());
    }

    public void visitClass(ClassTree tree) {
        this.scan(tree.name());
        this.scan(tree.superClass());
        this.scan(tree.elements());
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameterClause());
        this.scan(tree.body());
    }

    public void visitParameterList(ParameterListTree tree) {
        this.scan(tree.parameters());
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameterClause());
        this.scan(tree.body());
    }

    public void visitBlock(BlockTree tree) {
        this.scan(tree.statements());
    }

    public void visitEmptyStatement(EmptyStatementTree tree) {
    }

    public void visitLabelledStatement(LabelledStatementTree tree) {
        this.scan(tree.label());
        this.scan(tree.statement());
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scan(tree.expression());
    }

    public void visitIfStatement(IfStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
        this.scan(tree.elseClause());
    }

    public void visitElseClause(ElseClauseTree tree) {
        this.scan(tree.statement());
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan(tree.condition());
        this.scan(tree.update());
        this.scan(tree.statement());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan(tree.statement());
        this.scan(tree.condition());
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        this.scan(tree.label());
    }

    public void visitIdentifier(IdentifierTree tree) {
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        this.scan(tree.label());
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        this.scan(tree.expression());
    }

    public void visitWithStatement(WithStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.cases());
    }

    public void visitDefaultClause(DefaultClauseTree tree) {
        this.scan(tree.statements());
    }

    public void visitCaseClause(CaseClauseTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statements());
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.scan(tree.expression());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.block());
        this.scan(tree.catchBlock());
        this.scan(tree.finallyBlock());
    }

    public void visitCatchBlock(CatchBlockTree tree) {
        this.scan(tree.parameter());
        this.scan(tree.block());
    }

    public void visitDebugger(DebuggerStatementTree tree) {
    }

    public void visitArrayBindingPattern(ArrayBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.scan(tree.properties());
    }

    public void visitBindingProperty(BindingPropertyTree tree) {
        this.scan(tree.name());
        this.scan(tree.value());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.scan(tree.left());
        this.scan(tree.right());
    }

    public void visitLiteral(LiteralTree tree) {
    }

    public void visitArrayLiteral(ArrayLiteralTree tree) {
        this.scan(tree.elements());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.condition());
        this.scan(tree.trueExpression());
        this.scan(tree.falseExpression());
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.scan(tree.parameterClause());
        this.scan(tree.body());
    }

    public void visitYieldExpression(YieldExpressionTree tree) {
        this.scan(tree.argument());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.leftOperand());
        this.scan(tree.rightOperand());
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.scan(tree.expression());
    }

    public void visitMemberExpression(MemberExpressionTree tree) {
        this.scan(tree.object());
        this.scan(tree.property());
    }

    public void visitTaggedTemplate(TaggedTemplateTree tree) {
        this.scan(tree.callee());
        this.scan(tree.template());
    }

    public void visitCallExpression(CallExpressionTree tree) {
        this.scan(tree.callee());
        this.scan(tree.arguments());
    }

    public void visitTemplateLiteral(TemplateLiteralTree tree) {
        this.scan(tree.strings());
        this.scan(tree.expressions());
    }

    public void visitTemplateExpression(TemplateExpressionTree tree) {
        this.scan(tree.expression());
    }

    public void visitTemplateCharacters(TemplateCharactersTree tree) {
    }

    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        this.scan(tree.expression());
    }

    public void visitComputedPropertyName(ComputedPropertyNameTree tree) {
        this.scan(tree.expression());
    }

    public void visitPairProperty(PairPropertyTree tree) {
        this.scan(tree.key());
        this.scan(tree.value());
    }

    public void visitNewExpression(NewExpressionTree tree) {
        this.scan(tree.expression());
        this.scan(tree.arguments());
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameterClause());
        this.scan(tree.body());
    }

    public void visitRestElement(RestElementTree tree) {
        this.scan(tree.element());
    }

    public void visitSuper(SuperTreeImpl tree) {
    }

    public void visitExportClause(ExportClauseTree tree) {
        this.scan(tree.exports());
        this.scan(tree.fromClause());
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }
}

