/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.BlockExecution;
import org.sonar.javascript.se.LocalVariables;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.SymbolicValue;
import org.sonar.javascript.se.Truthiness;
import org.sonar.javascript.se.TypeOf;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;

public class SymbolicExecution {
    private static final int MAX_BLOCK_EXECUTIONS = 1000;
    private final CfgBlock cfgStartBlock;
    private final Set<Symbol> trackedVariables;
    private final Set<Symbol> functionParameters;
    private final Scope functionScope;
    private final Deque<BlockExecution> workList = new ArrayDeque<BlockExecution>();
    private final SetMultimap<Tree, Truthiness> conditionResults = HashMultimap.create();
    private final Set<BlockExecution> alreadyProcessed = new HashSet<BlockExecution>();
    private final List<SeCheck> checks;

    public SymbolicExecution(Scope functionScope, ControlFlowGraph cfg, List<SeCheck> checks) {
        this.cfgStartBlock = cfg.start();
        LocalVariables localVariables = new LocalVariables(functionScope, cfg);
        this.trackedVariables = localVariables.trackableVariables();
        this.functionParameters = localVariables.functionParameters();
        this.functionScope = functionScope;
        this.checks = checks;
    }

    public void visitCfg() {
        for (SeCheck check : this.checks) {
            check.startOfExecution(this.functionScope);
        }
        this.workList.addLast(new BlockExecution(this.cfgStartBlock, this.initialState()));
        for (int i = 0; i < 1000 && !this.workList.isEmpty(); ++i) {
            BlockExecution blockExecution = this.workList.removeFirst();
            if (this.alreadyProcessed.contains(blockExecution)) continue;
            if (SymbolicExecution.hasTryBranchingTree(blockExecution.block())) {
                return;
            }
            this.execute(blockExecution);
            this.alreadyProcessed.add(blockExecution);
        }
        if (this.workList.isEmpty()) {
            for (SeCheck check : this.checks) {
                check.checkConditions(this.conditionResults.asMap());
                check.endOfExecution(this.functionScope);
            }
        }
    }

    private static boolean hasTryBranchingTree(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            return ((CfgBranchingBlock)block).branchingTree().is(Tree.Kind.TRY_STATEMENT);
        }
        return false;
    }

    private ProgramState initialState() {
        ProgramState initialState = ProgramState.emptyState();
        for (Symbol localVar : this.trackedVariables) {
            SymbolicValue initialValue = SymbolicExecution.symbolIs(localVar, Symbol.Kind.FUNCTION, Symbol.Kind.IMPORT, Symbol.Kind.CLASS) ? SymbolicValue.UNKNOWN : (this.functionParameters.contains(localVar) ? SymbolicValue.UNKNOWN : SymbolicValue.UNDEFINED);
            initialState = initialState.copyAndAddValue(localVar, initialValue);
        }
        Symbol arguments = this.functionScope.getSymbol("arguments");
        initialState = initialState.copyAndAddValue(arguments, SymbolicValue.UNKNOWN);
        initialState = initialState.constrain(arguments, Truthiness.TRUTHY);
        return initialState;
    }

    private static boolean symbolIs(Symbol symbol, Symbol.Kind ... kinds) {
        for (Symbol.Kind kind : kinds) {
            if (!symbol.kind().equals((Object)kind)) continue;
            return true;
        }
        return false;
    }

    private void execute(BlockExecution blockExecution) {
        CfgBlock block = blockExecution.block();
        ProgramState currentState = blockExecution.state();
        boolean stopExploring = false;
        for (Tree element : block.elements()) {
            Symbol symbol;
            ExpressionTree object;
            AssignmentExpressionTree assignment;
            this.beforeBlockElement(currentState, element);
            if (element.is(Tree.Kind.ASSIGNMENT)) {
                assignment = (AssignmentExpressionTree)element;
                currentState = this.store(currentState, (Tree)assignment.variable(), assignment.expression());
            } else if (TreeKinds.isAssignment(element)) {
                assignment = (AssignmentExpressionTree)element;
                currentState = this.store(currentState, (Tree)assignment.variable(), SymbolicValue.UNKNOWN);
            } else if (element.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT)) {
                UnaryExpressionTree unary = (UnaryExpressionTree)element;
                currentState = this.store(currentState, (Tree)unary.expression(), SymbolicValue.UNKNOWN);
            } else if (element.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                InitializedBindingElementTree initialized = (InitializedBindingElementTree)element;
                currentState = this.store(currentState, (Tree)initialized.left(), initialized.right());
            } else if (element.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION) && (object = ((MemberExpressionTree)element).object()).is(Tree.Kind.IDENTIFIER_REFERENCE) && (symbol = ((IdentifierTree)object).symbol()) != null) {
                SymbolicValue symbolicValue = currentState.get(symbol);
                if (symbolicValue != null && symbolicValue.nullability().equals((Object)Nullability.UNKNOWN)) {
                    currentState = currentState.constrain(symbol, Nullability.NOT_NULLY);
                } else if (symbolicValue != null && symbolicValue.nullability().isNullOrUndefined()) {
                    stopExploring = true;
                    break;
                }
            }
            this.afterBlockElement(currentState, element);
        }
        if (!stopExploring) {
            this.handleSuccessors(block, currentState);
        }
    }

    private void beforeBlockElement(ProgramState currentState, Tree element) {
        for (SeCheck check : this.checks) {
            check.beforeBlockElement(currentState, element);
        }
    }

    private void afterBlockElement(ProgramState currentState, Tree element) {
        for (SeCheck check : this.checks) {
            check.afterBlockElement(currentState, element);
        }
    }

    private void pushAllSuccessors(CfgBlock block, ProgramState currentState) {
        for (CfgBlock successor : block.successors()) {
            this.pushSuccessor(successor, currentState);
        }
    }

    private void pushSuccessor(CfgBlock successor, ProgramState currentState) {
        this.workList.addLast(new BlockExecution(successor, currentState));
    }

    private void handleSuccessors(CfgBlock block, ProgramState incomingState) {
        ProgramState currentState = incomingState;
        if (block instanceof CfgBranchingBlock) {
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            Tree branchingTree = branchingBlock.branchingTree();
            if (branchingTree.is(Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
                this.handleConditionSuccessors(branchingBlock, currentState);
                return;
            }
            if (branchingTree.is(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT)) {
                ForObjectStatementTree forTree = (ForObjectStatementTree)branchingTree;
                Tree variable = forTree.variableOrExpression();
                if (variable.is(Tree.Kind.VAR_DECLARATION)) {
                    VariableDeclarationTree declaration = (VariableDeclarationTree)variable;
                    variable = declaration.variables().get(0);
                }
                currentState = this.store(currentState, variable, SymbolicValue.UNKNOWN);
                Symbol symbol = this.trackedVariable(forTree.expression());
                if (symbol != null && currentState.get(symbol) != null && currentState.get(symbol).nullability().isNullOrUndefined()) {
                    this.pushSuccessor(branchingBlock.falseSuccessor(), currentState);
                    return;
                }
            }
        }
        this.pushAllSuccessors(block, currentState);
    }

    private void handleConditionSuccessors(CfgBranchingBlock block, ProgramState currentState) {
        Tree lastElement = block.elements().get(block.elements().size() - 1);
        if (!(this.handleConditionBooleanLiteral(block, currentState, lastElement) || this.handleConditionTypeOf(block, currentState, lastElement) || this.handleConditionVariableOrUnaryNot(block, currentState, lastElement) || this.handleConditionStrictEqual(block, currentState, lastElement) || this.handleConditionEqualNull(block, currentState, lastElement))) {
            this.pushAllSuccessors(block, currentState);
        }
    }

    private boolean handleConditionTypeOf(CfgBranchingBlock block, ProgramState currentState, Tree lastElement) {
        ExpressionTree typeOfOperand = null;
        LiteralTree literal = null;
        if (lastElement.is(Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO)) {
            BinaryExpressionTree expression = (BinaryExpressionTree)lastElement;
            ExpressionTree left = expression.leftOperand();
            ExpressionTree right = expression.rightOperand();
            if (left.is(Tree.Kind.TYPEOF) && right.is(Tree.Kind.STRING_LITERAL)) {
                typeOfOperand = ((UnaryExpressionTree)left).expression();
                literal = (LiteralTree)right;
            } else if (right.is(Tree.Kind.TYPEOF) && left.is(Tree.Kind.STRING_LITERAL)) {
                typeOfOperand = ((UnaryExpressionTree)right).expression();
                literal = (LiteralTree)left;
            }
        }
        if (typeOfOperand != null) {
            String value = literal.value().substring(1, literal.value().length() - 1);
            Nullability trueSuccessorNullability = null;
            Nullability falseSuccessorNullability = null;
            Symbol conditionVariable = this.trackedVariable(typeOfOperand);
            if (conditionVariable != null) {
                Truthiness conditionTruthiness = SymbolicExecution.getTypeOfConditionTruthiness(lastElement, value, currentState, conditionVariable);
                this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
                if (conditionTruthiness.equals((Object)Truthiness.UNKNOWN)) {
                    if (lastElement.is(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO)) {
                        trueSuccessorNullability = TypeOf.typeOfEqualNullability.get(value);
                        falseSuccessorNullability = TypeOf.typeOfNotEqualNullability.get(value);
                    } else {
                        trueSuccessorNullability = TypeOf.typeOfNotEqualNullability.get(value);
                        falseSuccessorNullability = TypeOf.typeOfEqualNullability.get(value);
                    }
                }
                if (conditionTruthiness != Truthiness.FALSY) {
                    this.pushSuccessor(block.trueSuccessor(), currentState.constrain(conditionVariable, trueSuccessorNullability));
                }
                if (conditionTruthiness != Truthiness.TRUTHY) {
                    this.pushSuccessor(block.falseSuccessor(), currentState.constrain(conditionVariable, falseSuccessorNullability));
                }
                return true;
            }
        }
        return false;
    }

    private static Truthiness getTypeOfConditionTruthiness(Tree expression, String typeValue, ProgramState currentState, Symbol conditionVariable) {
        String typeOf;
        Truthiness truthiness;
        Truthiness conditionTruthiness = Truthiness.UNKNOWN;
        Truthiness truthiness2 = truthiness = expression.is(Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO) ? Truthiness.TRUTHY : Truthiness.FALSY;
        if (!TypeOf.isValidType(typeValue)) {
            conditionTruthiness = truthiness.not();
        } else if (currentState.get(conditionVariable) != null && (typeOf = TypeOf.typeOf(currentState.get(conditionVariable))) != null) {
            conditionTruthiness = typeValue.equals(typeOf) ? truthiness : truthiness.not();
        }
        return conditionTruthiness;
    }

    private boolean handleConditionEqualNull(CfgBranchingBlock block, ProgramState currentState, Tree lastElement) {
        if (SymbolicExecution.isNullyComparison(lastElement)) {
            Nullability falseSuccessorNullability;
            Nullability trueSuccessorNullability;
            if (lastElement.is(Tree.Kind.EQUAL_TO)) {
                trueSuccessorNullability = Nullability.NULLY;
                falseSuccessorNullability = Nullability.NOT_NULLY;
            } else {
                trueSuccessorNullability = Nullability.NOT_NULLY;
                falseSuccessorNullability = Nullability.NULLY;
            }
            Symbol conditionVariable = this.trackedOperand((BinaryExpressionTree)lastElement);
            if (conditionVariable != null) {
                Nullability currentNullability = currentState.get(conditionVariable).nullability();
                Truthiness truthinessIfVariableNull = lastElement.is(Tree.Kind.EQUAL_TO) ? Truthiness.TRUTHY : Truthiness.FALSY;
                Truthiness conditionTruthiness = Truthiness.UNKNOWN;
                if (currentNullability.isNullOrUndefined()) {
                    conditionTruthiness = truthinessIfVariableNull;
                } else if (currentNullability.isNeitherNullNorUndefined()) {
                    conditionTruthiness = truthinessIfVariableNull.not();
                }
                this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
                if (conditionTruthiness != Truthiness.FALSY) {
                    this.pushSuccessor(block.trueSuccessor(), currentState.constrain(conditionVariable, trueSuccessorNullability));
                }
                if (conditionTruthiness != Truthiness.TRUTHY) {
                    this.pushSuccessor(block.falseSuccessor(), currentState.constrain(conditionVariable, falseSuccessorNullability));
                }
                return true;
            }
        }
        return false;
    }

    private boolean handleConditionStrictEqual(CfgBranchingBlock block, ProgramState currentState, Tree lastElement) {
        return this.handleConditionStrictEqual(block, currentState, lastElement, SymbolicValue.NULL, SymbolicValue.NOT_NULL) || this.handleConditionStrictEqual(block, currentState, lastElement, SymbolicValue.UNDEFINED, SymbolicValue.NOT_UNDEFINED);
    }

    private boolean handleConditionStrictEqual(CfgBranchingBlock block, ProgramState currentState, Tree lastElement, SymbolicValue value, SymbolicValue valueNot) {
        if (SymbolicExecution.isStrictComparison(lastElement, value)) {
            Nullability falseSuccessorNullability;
            Nullability trueSuccessorNullability;
            if (lastElement.is(Tree.Kind.STRICT_EQUAL_TO)) {
                trueSuccessorNullability = value.nullability();
                falseSuccessorNullability = valueNot.nullability();
            } else {
                trueSuccessorNullability = valueNot.nullability();
                falseSuccessorNullability = value.nullability();
            }
            Symbol conditionVariable = this.trackedOperand((BinaryExpressionTree)lastElement);
            if (conditionVariable != null) {
                Nullability currentNullability = currentState.get(conditionVariable).nullability();
                Truthiness truthinessIfVariableNull = lastElement.is(Tree.Kind.STRICT_EQUAL_TO) ? Truthiness.TRUTHY : Truthiness.FALSY;
                Truthiness conditionTruthiness = Truthiness.UNKNOWN;
                if (currentNullability.equals((Object)value.nullability())) {
                    conditionTruthiness = truthinessIfVariableNull;
                } else if (currentNullability.canNotBeEqual(value.nullability())) {
                    conditionTruthiness = truthinessIfVariableNull.not();
                }
                this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
                if (conditionTruthiness != Truthiness.FALSY) {
                    this.pushSuccessor(block.trueSuccessor(), currentState.constrain(conditionVariable, trueSuccessorNullability));
                }
                if (conditionTruthiness != Truthiness.TRUTHY) {
                    this.pushSuccessor(block.falseSuccessor(), currentState.constrain(conditionVariable, falseSuccessorNullability));
                }
                return true;
            }
        }
        return false;
    }

    private boolean handleConditionVariableOrUnaryNot(CfgBranchingBlock block, ProgramState currentState, Tree lastElement) {
        Truthiness falseSuccessorTruthiness;
        Truthiness trueSuccessorTruthiness;
        Symbol conditionVariable;
        boolean isUnaryNot = lastElement.is(Tree.Kind.LOGICAL_COMPLEMENT);
        if (isUnaryNot) {
            UnaryExpressionTree unary = (UnaryExpressionTree)lastElement;
            conditionVariable = this.trackedVariable(unary.expression());
            trueSuccessorTruthiness = Truthiness.FALSY;
            falseSuccessorTruthiness = Truthiness.TRUTHY;
        } else {
            conditionVariable = this.trackedVariable(lastElement);
            trueSuccessorTruthiness = Truthiness.TRUTHY;
            falseSuccessorTruthiness = Truthiness.FALSY;
        }
        if (conditionVariable != null) {
            SymbolicValue currentValue = currentState.get(conditionVariable);
            Truthiness currentTruthiness = currentValue.truthiness();
            Truthiness conditionTruthiness = isUnaryNot ? currentTruthiness.not() : currentTruthiness;
            this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
            if (currentTruthiness != falseSuccessorTruthiness) {
                this.pushSuccessor(block.trueSuccessor(), currentState.constrain(conditionVariable, trueSuccessorTruthiness));
            }
            if (currentTruthiness != trueSuccessorTruthiness) {
                this.pushSuccessor(block.falseSuccessor(), currentState.constrain(conditionVariable, falseSuccessorTruthiness));
            }
            return true;
        }
        return false;
    }

    private boolean handleConditionBooleanLiteral(CfgBranchingBlock block, ProgramState currentState, Tree lastElement) {
        if (lastElement.is(Tree.Kind.BOOLEAN_LITERAL)) {
            SymbolicValue conditionValue = SymbolicValue.get((LiteralTree)lastElement);
            Truthiness conditionTruthiness = conditionValue.truthiness();
            if (!block.branchingTree().is(Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT)) {
                this.conditionResults.put((Object)lastElement, (Object)conditionTruthiness);
            }
            CfgBlock successor = conditionTruthiness == Truthiness.TRUTHY ? block.trueSuccessor() : block.falseSuccessor();
            this.pushSuccessor(successor, currentState);
            return true;
        }
        return false;
    }

    private static boolean isNullyComparison(Tree lastElement) {
        if (lastElement.is(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO)) {
            BinaryExpressionTree comparison = (BinaryExpressionTree)lastElement;
            return SymbolicValue.get(comparison.leftOperand()).nullability().isNullOrUndefined() || SymbolicValue.get(comparison.rightOperand()).nullability().isNullOrUndefined();
        }
        return false;
    }

    private static boolean isStrictComparison(Tree lastElement, SymbolicValue value) {
        if (lastElement.is(Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO)) {
            BinaryExpressionTree comparison = (BinaryExpressionTree)lastElement;
            return SymbolicValue.get(comparison.leftOperand()).equals(value) || SymbolicValue.get(comparison.rightOperand()).equals(value);
        }
        return false;
    }

    private ProgramState store(ProgramState currentState, Tree left, ExpressionTree right) {
        SymbolicValue symbolicValue = SymbolicValue.get(right);
        return this.store(currentState, left, symbolicValue);
    }

    private ProgramState store(ProgramState currentState, Tree left, SymbolicValue symbolicValue) {
        Symbol trackedVariable = this.trackedVariable(left);
        if (trackedVariable != null) {
            return currentState.copyAndAddValue(trackedVariable, symbolicValue);
        }
        return currentState;
    }

    @CheckForNull
    private Symbol trackedVariable(Tree tree) {
        if (tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return this.trackedVariable(((ParenthesisedExpressionTree)tree).expression());
        }
        if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)tree;
            Symbol symbol = identifier.symbol();
            return this.trackedVariables.contains(symbol) ? symbol : null;
        }
        return null;
    }

    @CheckForNull
    private Symbol trackedOperand(BinaryExpressionTree tree) {
        Symbol left = this.trackedVariable(tree.leftOperand());
        if (left != null) {
            return left;
        }
        return this.trackedVariable(tree.rightOperand());
    }
}

