/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.symbols;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.javascript.api.symbols.Type;

public class TypeSet
implements Set<Type> {
    private Set<Type> types = Sets.newHashSet();

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.types.contains(o);
    }

    @Override
    public Iterator<Type> iterator() {
        return this.types.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.types.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.types.toArray(a);
    }

    @Override
    public boolean add(Type type) {
        return this.types.add(type);
    }

    @Override
    public boolean remove(Object o) {
        return this.types.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.types.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Type> c) {
        return this.types.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.types.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.types.removeAll(c);
    }

    @Override
    public void clear() {
        this.types.clear();
    }

    public boolean containsOnlyAndUnique(Type.Kind kind) {
        return this.size() == 1 && this.iterator().next().kind() == kind;
    }

    public boolean contains(Type.Kind kind) {
        for (Type type : this.types) {
            if (type.kind() != kind) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnly(Type.Kind kind) {
        for (Type type : this.types) {
            if (type.kind() == kind) continue;
            return false;
        }
        return !this.types.isEmpty();
    }

    public static TypeSet emptyTypeSet() {
        return new TypeSet();
    }

    @Nullable
    public Type element() {
        if (this.isEmpty()) {
            return null;
        }
        return this.iterator().next();
    }

    @Nullable
    public Type getUniqueKnownType() {
        Type type;
        if (this.size() == 1 && !(type = this.iterator().next()).kind().equals((Object)Type.Kind.UNKNOWN)) {
            return type;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        return this.types.equals(o);
    }

    @Override
    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return this.types.toString();
    }

    public TypeSet immutableCopy() {
        TypeSet copy = new TypeSet();
        copy.types = Collections.unmodifiableSet(this.types);
        return copy;
    }

    @Nullable
    public Type getUniqueType(Type.Kind kind) {
        Type result = null;
        for (Type type : this.types) {
            if (!type.kind().equals((Object)kind)) continue;
            if (result == null) {
                result = type;
                continue;
            }
            return null;
        }
        return result;
    }
}

