/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.Truthiness;

public enum Constraint {
    NO_POSSIBLE_VALUE(0),
    NULL(1),
    UNDEFINED(2),
    NULL_OR_UNDEFINED(3),
    FALSY_NOT_NULLY(4),
    FALSY_NOT_UNDEFINED(5),
    FALSY_NOT_NULL(6),
    FALSY(7),
    TRUTHY(8),
    TRUTHY_OR_NULL(9),
    TRUTHY_OR_UNDEFINED(10),
    TRUTHY_OR_NULLY(11),
    NOT_NULLY(12),
    NOT_UNDEFINED(13),
    NOT_NULL(14),
    ANY_VALUE(15);

    private static final Constraint[] CONSTRAINTS;
    private int bitSet;

    private Constraint(int bitSet) {
        this.bitSet = bitSet;
    }

    private static Constraint get(int bitSet) {
        return CONSTRAINTS[bitSet];
    }

    public Constraint and(Constraint other) {
        return Constraint.get(this.bitSet & other.bitSet);
    }

    public Constraint not() {
        return Constraint.get(~this.bitSet & Constraint.ANY_VALUE.bitSet);
    }

    public Truthiness truthiness() {
        if (this.equals((Object)TRUTHY)) {
            return Truthiness.TRUTHY;
        }
        if (this.isIncompatibleWith(TRUTHY)) {
            return Truthiness.FALSY;
        }
        return Truthiness.UNKNOWN;
    }

    public Nullability nullability() {
        if (this.isStricterOrEqualTo(NULL_OR_UNDEFINED)) {
            return Nullability.NULL;
        }
        if (this.isStricterOrEqualTo(NOT_NULLY)) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    public boolean isStricterOrEqualTo(Constraint other) {
        return this.and(other).equals((Object)this);
    }

    public boolean isIncompatibleWith(Constraint other) {
        return this.and(other).equals((Object)NO_POSSIBLE_VALUE);
    }

    static {
        CONSTRAINTS = Constraint.values();
    }
}

