/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.sv.SimpleSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

public class ProgramState {
    private final ImmutableMap<Symbol, SymbolicValue> values;
    private final ImmutableMap<SymbolicValue, Constraint> constraints;
    private final ExpressionStack stack;
    private int counter;

    private ProgramState(ImmutableMap<Symbol, SymbolicValue> values, ImmutableMap<SymbolicValue, Constraint> constraints, ExpressionStack stack, int counter) {
        HashSet<SymbolicValue> allReferencedValues = new HashSet<SymbolicValue>((Collection<SymbolicValue>)values.values());
        if (!stack.isEmpty()) {
            allReferencedValues.add(stack.peek());
        }
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : constraints.entrySet()) {
            if (!allReferencedValues.contains(entry.getKey())) continue;
            constraintsBuilder.put(entry.getKey(), entry.getValue());
        }
        this.values = values;
        this.constraints = constraintsBuilder.build();
        this.stack = stack;
        this.counter = counter;
    }

    public static ProgramState emptyState() {
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.of(), (ImmutableMap<SymbolicValue, Constraint>)ImmutableMap.of(), ExpressionStack.emptyStack(), 0);
    }

    private ProgramState addConstraint(SymbolicValue value, Constraint constraint) {
        if (this.constraints.containsKey((Object)value)) {
            throw new IllegalStateException();
        }
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        constraintsBuilder.putAll(this.constraints);
        constraintsBuilder.put((Object)value, (Object)constraint);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(this.values), (ImmutableMap<SymbolicValue, Constraint>)constraintsBuilder.build(), this.stack, this.counter);
    }

    public ProgramState newSymbolicValue(Symbol symbol, @Nullable Constraint constraint) {
        SymbolicValue value = this.newSymbolicValue();
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.values.entrySet()) {
            if (((Symbol)entry.getKey()).equals(symbol)) continue;
            valuesBuilder.put(entry.getKey(), entry.getValue());
        }
        valuesBuilder.put((Object)symbol, (Object)value);
        ProgramState newProgramState = new ProgramState((ImmutableMap<Symbol, SymbolicValue>)valuesBuilder.build(), (ImmutableMap<SymbolicValue, Constraint>)ImmutableMap.copyOf(this.constraints), this.stack, this.counter);
        if (constraint != null) {
            newProgramState = newProgramState.addConstraint(value, constraint);
        }
        return newProgramState;
    }

    public ProgramState constrain(@Nullable SymbolicValue value, @Nullable Constraint constraint) {
        if (value == null || constraint == null) {
            return this;
        }
        if (this.getConstraint(value).isIncompatibleWith(constraint)) {
            return null;
        }
        Constraint newConstraint = this.getConstraint(value).and(constraint);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(this.values), this.replaceConstraint(value, newConstraint), this.stack, this.counter);
    }

    private ImmutableMap<SymbolicValue, Constraint> replaceConstraint(SymbolicValue value, Constraint newConstraint) {
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.constraints.entrySet()) {
            if (((SymbolicValue)entry.getKey()).equals(value)) continue;
            constraintsBuilder.put(entry.getKey(), entry.getValue());
        }
        constraintsBuilder.put((Object)value, (Object)newConstraint);
        return constraintsBuilder.build();
    }

    private SymbolicValue newSymbolicValue() {
        SimpleSymbolicValue value = new SimpleSymbolicValue(this.counter);
        ++this.counter;
        return value;
    }

    @CheckForNull
    public SymbolicValue getSymbolicValue(@Nullable Symbol symbol) {
        return (SymbolicValue)this.values.get((Object)symbol);
    }

    public Constraint getConstraint(@Nullable SymbolicValue value) {
        Constraint constraint = (Constraint)((Object)this.constraints.get((Object)value));
        if (constraint == null) {
            return Constraint.ANY_VALUE;
        }
        return constraint;
    }

    public Constraint getConstraint(@Nullable Symbol symbol) {
        return this.getConstraint(this.getSymbolicValue(symbol));
    }

    public Nullability getNullability(@Nullable SymbolicValue value) {
        return this.getConstraint(value).nullability();
    }

    public Map<Symbol, Constraint> constraintsBySymbol() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : this.values.entrySet()) {
            if (this.constraints.get(entry.getValue()) == null) continue;
            builder.put(entry.getKey(), this.constraints.get(entry.getValue()));
        }
        return builder.build();
    }

    public ProgramState pushToStack(@Nullable SymbolicValue value) {
        return new ProgramState(this.values, this.constraints, this.stack.push(value), this.counter);
    }

    public ProgramState clearStack() {
        return new ProgramState(this.values, this.constraints, ExpressionStack.emptyStack(), this.counter);
    }

    public ProgramState execute(ExpressionTree expression) {
        return new ProgramState(this.values, this.constraints, this.stack.execute(expression), this.counter);
    }

    public ProgramState assignment(Symbol variable) {
        SymbolicValue value = this.stack.peek();
        ExpressionStack newStack = this.stack;
        if (UnknownSymbolicValue.UNKNOWN.equals(value)) {
            value = this.newSymbolicValue();
            newStack = newStack.removeLastValue();
            newStack = newStack.push(value);
        }
        HashMap<Symbol, SymbolicValue> newValues = new HashMap<Symbol, SymbolicValue>((Map<Symbol, SymbolicValue>)this.values);
        newValues.put(variable, value);
        ProgramState newState = new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(newValues), this.constraints, newStack, this.counter);
        newState = newState.constrain(value, value.inherentConstraint());
        return newState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.constraintsBySymbol(), that.constraintsBySymbol()) && Objects.equals(this.stack, that.stack) && Objects.equals((Object)this.constraintOnPeek(), (Object)that.constraintOnPeek());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constraintsBySymbol(), this.stack, this.constraintOnPeek()});
    }

    @CheckForNull
    private Constraint constraintOnPeek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return (Constraint)((Object)this.constraints.get((Object)this.peekStack()));
    }

    public SymbolicValue peekStack() {
        return this.stack.peek();
    }

    public ProgramState removeSymbols(Set<Symbol> symbolsToKeep) {
        Map newValues = Maps.filterKeys(this.values, (Predicate)Predicates.in(symbolsToKeep));
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf((Map)newValues), this.constraints, this.stack, this.counter);
    }

    public String toString() {
        return "[" + this.values + ";" + this.constraints + ";" + this.stack + "]";
    }
}

