/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LiteralSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.TypeOfSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class TypeOfComparisonSymbolicValue
implements SymbolicValue {
    private final TypeOfSymbolicValue typeOfOperand;
    private final String comparedTypeString;
    private static final Map<String, Constraint> TYPEOF_EQUAL_CONSTRAINTS = ImmutableMap.builder().put((Object)"undefined", (Object)Constraint.UNDEFINED).put((Object)"function", (Object)Constraint.TRUTHY).put((Object)"object", (Object)Constraint.TRUTHY_OR_NULL).put((Object)"number", (Object)Constraint.NOT_NULLY).put((Object)"string", (Object)Constraint.NOT_NULLY).put((Object)"boolean", (Object)Constraint.NOT_NULLY).put((Object)"symbol", (Object)Constraint.NOT_NULLY).build();
    private static final Map<String, Constraint> TYPEOF_NOT_EQUAL_CONSTRAINTS = ImmutableMap.builder().put((Object)"undefined", (Object)Constraint.UNDEFINED.not()).put((Object)"object", (Object)Constraint.NULL.not()).build();

    @CheckForNull
    public static TypeOfComparisonSymbolicValue create(SymbolicValue operand1, SymbolicValue operand2) {
        TypeOfComparisonSymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand1, operand2);
        if (typeOfComparison == null) {
            typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand2, operand1);
        }
        return typeOfComparison;
    }

    @CheckForNull
    private static TypeOfComparisonSymbolicValue createTypeOfComparison(SymbolicValue operand1, SymbolicValue operand2) {
        LiteralTree literal;
        if (operand1 instanceof TypeOfSymbolicValue && operand2 instanceof LiteralSymbolicValue && (literal = ((LiteralSymbolicValue)operand2).getLiteral()).is(Tree.Kind.STRING_LITERAL)) {
            return new TypeOfComparisonSymbolicValue((TypeOfSymbolicValue)operand1, literal.value().substring(1, literal.value().length() - 1));
        }
        return null;
    }

    private TypeOfComparisonSymbolicValue(TypeOfSymbolicValue typeOfOperand, String comparedTypeString) {
        Preconditions.checkArgument((typeOfOperand != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        Preconditions.checkArgument((comparedTypeString != null ? 1 : 0) != 0, (Object)"comparedTypeString should not be null");
        this.typeOfOperand = typeOfOperand;
        this.comparedTypeString = comparedTypeString;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        Constraint truthyConstraint = TYPEOF_EQUAL_CONSTRAINTS.get(this.comparedTypeString);
        Constraint falsyConstraint = TYPEOF_NOT_EQUAL_CONSTRAINTS.get(this.comparedTypeString);
        if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return truthyConstraint != null ? this.typeOfOperand.constrain(state, truthyConstraint) : ImmutableList.of();
        }
        if (constraint.isStricterOrEqualTo(Constraint.FALSY) && falsyConstraint != null) {
            return this.typeOfOperand.constrain(state, falsyConstraint);
        }
        return ImmutableList.of((Object)state);
    }

    public String toString() {
        return this.typeOfOperand + " == '" + this.comparedTypeString + "'";
    }
}

