/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.tree.JavaScriptCommentAnalyser;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

public class CommentLineVisitor
extends SubscriptionVisitor {
    private Set<Integer> comments = Sets.newHashSet();
    private Set<Integer> noSonarLines = Sets.newHashSet();
    private boolean seenFirstToken;
    private boolean ignoreHeaderComments;
    private JavaScriptCommentAnalyser commentAnalyser = new JavaScriptCommentAnalyser();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN));
    }

    public CommentLineVisitor(Tree tree, boolean ignoreHeaderComments) {
        this.ignoreHeaderComments = ignoreHeaderComments;
        this.comments.clear();
        this.noSonarLines.clear();
        this.seenFirstToken = false;
        this.scanTree(tree);
    }

    @Override
    public void visitNode(Tree tree) {
        for (SyntaxTrivia trivia : ((SyntaxToken)tree).trivias()) {
            if (this.ignoreHeaderComments && this.seenFirstToken || !this.ignoreHeaderComments) {
                String[] commentLines = this.commentAnalyser.getContents(trivia.text()).split("(\r)?\n|\r", -1);
                int lineNumber = trivia.line();
                for (String commentLine : commentLines) {
                    if (commentLine.contains("NOSONAR")) {
                        this.noSonarLines.add(lineNumber);
                    } else if (!this.commentAnalyser.isBlank(commentLine)) {
                        this.comments.add(lineNumber);
                    }
                    ++lineNumber;
                }
                continue;
            }
            this.seenFirstToken = true;
        }
        this.seenFirstToken = true;
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }

    public Set<Integer> getCommentLines() {
        return this.comments;
    }

    public int getCommentLineNumber() {
        return this.comments.size();
    }
}

