/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.BlockExecution;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.LiveVariableAnalysis;
import org.sonar.javascript.se.LocalVariables;
import org.sonar.javascript.se.Nullability;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Truthiness;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;

public class SymbolicExecution {
    private static final int MAX_BLOCK_EXECUTIONS = 1000;
    private final CfgBlock cfgStartBlock;
    private final Set<Symbol> trackedVariables;
    private final Set<Symbol> functionParameters;
    private final Scope functionScope;
    private final Deque<BlockExecution> workList = new ArrayDeque<BlockExecution>();
    private final SetMultimap<Tree, Truthiness> conditionResults = HashMultimap.create();
    private final Set<BlockExecution> alreadyProcessed = new HashSet<BlockExecution>();
    private final List<SeCheck> checks;
    private final LiveVariableAnalysis liveVariableAnalysis;

    public SymbolicExecution(Scope functionScope, ControlFlowGraph cfg, List<SeCheck> checks) {
        this.cfgStartBlock = cfg.start();
        LocalVariables localVariables = new LocalVariables(functionScope, cfg);
        this.trackedVariables = localVariables.trackableVariables();
        this.functionParameters = localVariables.functionParameters();
        this.liveVariableAnalysis = LiveVariableAnalysis.create(cfg, functionScope);
        this.functionScope = functionScope;
        this.checks = checks;
    }

    public void visitCfg() {
        for (SeCheck check : this.checks) {
            check.startOfExecution(this.functionScope);
        }
        this.workList.addLast(new BlockExecution(this.cfgStartBlock, this.initialState()));
        for (int i = 0; i < 1000 && !this.workList.isEmpty(); ++i) {
            BlockExecution blockExecution = this.workList.removeFirst();
            if (this.alreadyProcessed.contains(blockExecution)) continue;
            if (SymbolicExecution.hasTryBranchingTree(blockExecution.block())) {
                return;
            }
            this.execute(blockExecution);
            this.alreadyProcessed.add(blockExecution);
        }
        if (this.workList.isEmpty()) {
            for (SeCheck check : this.checks) {
                check.checkConditions(this.conditionResults.asMap());
                check.endOfExecution(this.functionScope);
            }
        }
    }

    private static boolean hasTryBranchingTree(CfgBlock block) {
        if (block instanceof CfgBranchingBlock) {
            return ((CfgBranchingBlock)block).branchingTree().is(Tree.Kind.TRY_STATEMENT);
        }
        return false;
    }

    private ProgramState initialState() {
        ProgramState initialState = ProgramState.emptyState();
        for (Symbol localVar : this.trackedVariables) {
            Constraint initialConstraint = null;
            if (!SymbolicExecution.symbolIs(localVar, Symbol.Kind.FUNCTION, Symbol.Kind.IMPORT, Symbol.Kind.CLASS) && !this.functionParameters.contains(localVar)) {
                initialConstraint = Constraint.UNDEFINED;
            } else if (SymbolicExecution.symbolIs(localVar, Symbol.Kind.FUNCTION)) {
                initialConstraint = Constraint.FUNCTION;
            } else if (SymbolicExecution.symbolIs(localVar, Symbol.Kind.CLASS)) {
                initialConstraint = Constraint.OTHER_OBJECT;
            }
            initialState = initialState.newSymbolicValue(localVar, initialConstraint);
        }
        Symbol arguments = this.functionScope.getSymbol("arguments");
        if (arguments != null) {
            initialState = initialState.newSymbolicValue(arguments, Constraint.OBJECT);
        }
        return initialState;
    }

    private static boolean symbolIs(Symbol symbol, Symbol.Kind ... kinds) {
        for (Symbol.Kind kind : kinds) {
            if (!symbol.kind().equals((Object)kind)) continue;
            return true;
        }
        return false;
    }

    private void execute(BlockExecution blockExecution) {
        CfgBlock block = blockExecution.block();
        ProgramState currentState = blockExecution.state();
        boolean stopExploring = false;
        for (Tree element : block.elements()) {
            ExpressionTree object;
            this.beforeBlockElement(currentState, element);
            if (element.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION) && (object = ((MemberExpressionTree)element).object()).is(Tree.Kind.IDENTIFIER_REFERENCE)) {
                SymbolicValue symbolicValue = currentState.getSymbolicValue(((IdentifierTree)object).symbol());
                Nullability nullability = currentState.getNullability(symbolicValue);
                if (nullability == Nullability.UNKNOWN) {
                    currentState = currentState.constrain(symbolicValue, Constraint.NOT_NULLY);
                } else if (nullability == Nullability.NULL) {
                    stopExploring = true;
                    break;
                }
            }
            if (element.is(Tree.Kind.IDENTIFIER_REFERENCE) && !SymbolicExecution.isUndefined((IdentifierTree)element)) {
                SymbolicValue symbolicValue = currentState.getSymbolicValue(((IdentifierTree)element).symbol());
                currentState = currentState.pushToStack(symbolicValue);
            } else if (element instanceof ExpressionTree && !element.is(Tree.Kind.CLASS_DECLARATION)) {
                currentState = currentState.execute((ExpressionTree)element);
            }
            if (TreeKinds.isAssignment(element)) {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)element;
                currentState = this.assignment(currentState, assignment.variable());
            } else if (element.is(Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT)) {
                UnaryExpressionTree unary = (UnaryExpressionTree)element;
                currentState = this.assignment(currentState, unary.expression());
            } else if (element.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                InitializedBindingElementTree initialized = (InitializedBindingElementTree)element;
                BindingElementTree variable = initialized.left();
                if (variable.is(Tree.Kind.BINDING_IDENTIFIER)) {
                    currentState = this.assignment(currentState, variable);
                }
                currentState = currentState.clearStack(element);
            }
            this.afterBlockElement(currentState, element);
            if (!SymbolicExecution.isProducingUnconsumedValue(element)) continue;
            currentState = currentState.clearStack(element);
        }
        if (!stopExploring) {
            this.handleSuccessors(block, currentState);
        }
    }

    private static boolean isProducingUnconsumedValue(Tree element) {
        if (element instanceof ExpressionTree) {
            Tree tree = SymbolicExecution.syntaxTree(element);
            Tree parent = SymbolicExecution.getParent(tree);
            if (parent.is(Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.CASE_CLAUSE, Tree.Kind.WITH_STATEMENT)) {
                return true;
            }
            if (parent.is(Tree.Kind.FOR_STATEMENT)) {
                ForStatementTree forStatementTree = (ForStatementTree)parent;
                return tree.equals(forStatementTree.init()) || tree.equals(forStatementTree.update());
            }
        }
        return false;
    }

    private static Tree getParent(Tree tree) {
        return SymbolicExecution.syntaxTree(((JavaScriptTree)tree).getParent());
    }

    private static Tree syntaxTree(Tree tree) {
        Tree syntaxTree = tree;
        while (syntaxTree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            syntaxTree = ((JavaScriptTree)syntaxTree).getParent();
        }
        return syntaxTree;
    }

    public static boolean isUndefined(IdentifierTree tree) {
        return "undefined".equals(tree.name());
    }

    private void beforeBlockElement(ProgramState currentState, Tree element) {
        for (SeCheck check : this.checks) {
            check.beforeBlockElement(currentState, element);
        }
    }

    private void afterBlockElement(ProgramState currentState, Tree element) {
        for (SeCheck check : this.checks) {
            check.afterBlockElement(currentState, element);
        }
    }

    private void pushAllSuccessors(CfgBlock block, ProgramState currentState) {
        for (CfgBlock successor : block.successors()) {
            this.pushSuccessor(successor, currentState);
        }
    }

    private void pushSuccessor(CfgBlock successor, @Nullable ProgramState currentState) {
        if (currentState != null) {
            Set<Symbol> liveInSymbols = this.liveVariableAnalysis.getLiveInSymbols(successor);
            this.workList.addLast(new BlockExecution(successor, currentState.removeSymbols(liveInSymbols)));
        }
    }

    private void handleSuccessors(CfgBlock block, ProgramState incomingState) {
        ProgramState currentState = incomingState;
        boolean shouldPushAllSuccessors = true;
        if (block instanceof CfgBranchingBlock) {
            CfgBranchingBlock branchingBlock = (CfgBranchingBlock)block;
            Tree branchingTree = branchingBlock.branchingTree();
            if (branchingTree.is(Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
                this.pushConditionSuccessors(branchingBlock, currentState);
                shouldPushAllSuccessors = false;
            } else if (branchingTree.is(Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT)) {
                ForObjectStatementTree forTree = (ForObjectStatementTree)branchingTree;
                Tree variable = forTree.variableOrExpression();
                if (variable.is(Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION)) {
                    VariableDeclarationTree declaration = (VariableDeclarationTree)variable;
                    variable = declaration.variables().get(0);
                }
                if ((currentState = this.newSymbolicValue(currentState, variable)).getNullability(this.getSymbolicValue(forTree.expression(), currentState)) == Nullability.NULL) {
                    this.pushSuccessor(branchingBlock.falseSuccessor(), currentState);
                    shouldPushAllSuccessors = false;
                }
            }
        }
        if (shouldPushAllSuccessors) {
            this.pushAllSuccessors(block, currentState);
        }
    }

    private void pushConditionSuccessors(CfgBranchingBlock block, ProgramState currentState) {
        SymbolicValue conditionSymbolicValue = currentState.peekStack();
        ProgramState psWithPoppedStack = currentState.removeLastValue();
        if (block.branchingTree().is(Tree.Kind.IF_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT)) {
            psWithPoppedStack.assertEmptyStack(block.branchingTree());
        }
        Tree lastElement = block.elements().get(block.elements().size() - 1);
        for (ProgramState newState : conditionSymbolicValue.constrain(psWithPoppedStack, Constraint.TRUTHY)) {
            this.pushConditionSuccessor(block.trueSuccessor(), newState, conditionSymbolicValue, Constraint.TRUTHY);
            this.conditionResults.put((Object)lastElement, (Object)Truthiness.TRUTHY);
        }
        for (ProgramState newState : conditionSymbolicValue.constrain(psWithPoppedStack, Constraint.FALSY)) {
            this.pushConditionSuccessor(block.falseSuccessor(), newState, conditionSymbolicValue, Constraint.FALSY);
            this.conditionResults.put((Object)lastElement, (Object)Truthiness.FALSY);
        }
    }

    private void pushConditionSuccessor(CfgBlock successor, ProgramState programState, SymbolicValue conditionSymbolicValue, Constraint constraint) {
        ProgramState state = programState;
        if (!successor.elements().isEmpty() && successor.elements().get(0).is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            SymbolicValue conditionValue = conditionSymbolicValue;
            if (UnknownSymbolicValue.UNKNOWN.equals(conditionSymbolicValue)) {
                conditionValue = new SymbolicValueWithConstraint(constraint);
            }
            state = state.pushToStack(conditionValue);
        }
        this.pushSuccessor(successor, state);
    }

    private ProgramState newSymbolicValue(ProgramState currentState, Tree left) {
        Symbol trackedVariable = this.trackedVariable(left);
        if (trackedVariable != null) {
            return currentState.newSymbolicValue(trackedVariable, null);
        }
        return currentState;
    }

    private ProgramState assignment(ProgramState currentState, Tree variable) {
        Symbol trackedVariable = this.trackedVariable(variable);
        if (trackedVariable != null) {
            return currentState.assignment(trackedVariable);
        }
        return currentState;
    }

    @CheckForNull
    private Symbol trackedVariable(Tree tree) {
        if (tree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return this.trackedVariable(((ParenthesisedExpressionTree)tree).expression());
        }
        if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.BINDING_IDENTIFIER)) {
            IdentifierTree identifier = (IdentifierTree)tree;
            Symbol symbol = identifier.symbol();
            return this.trackedVariables.contains(symbol) ? symbol : null;
        }
        return null;
    }

    @CheckForNull
    private SymbolicValue getSymbolicValue(@Nullable Tree tree, ProgramState currentState) {
        Symbol symbol;
        if (tree != null && (symbol = this.trackedVariable(tree)) != null) {
            return currentState.getSymbolicValue(symbol);
        }
        return null;
    }
}

