/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.TypeOfComparisonSymbolicValue;

public class EqualToSymbolicValue
implements SymbolicValue {
    private static final Map<SpecialSymbolicValue, Constraint> EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)Constraint.NULL_OR_UNDEFINED, (Object)SpecialSymbolicValue.UNDEFINED, (Object)Constraint.NULL_OR_UNDEFINED);
    private static final Map<SpecialSymbolicValue, Constraint> NOT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)Constraint.NOT_NULLY, (Object)SpecialSymbolicValue.UNDEFINED, (Object)Constraint.NOT_NULLY);
    private static final Map<SpecialSymbolicValue, Constraint> STRICT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)Constraint.NULL, (Object)SpecialSymbolicValue.UNDEFINED, (Object)Constraint.UNDEFINED);
    private static final Map<SpecialSymbolicValue, Constraint> STRICT_NOT_EQUAL_CONSTRAINTS = ImmutableMap.of((Object)SpecialSymbolicValue.NULL, (Object)Constraint.NULL.not(), (Object)SpecialSymbolicValue.UNDEFINED, (Object)Constraint.UNDEFINED.not());
    private final SymbolicValue firstOperandValue;
    private final Constraint secondOperandConstraint;

    public EqualToSymbolicValue(SymbolicValue firstOperandValue, Constraint constraint) {
        Preconditions.checkArgument((firstOperandValue != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        this.firstOperandValue = firstOperandValue;
        this.secondOperandConstraint = constraint;
    }

    public static SymbolicValue createEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(EQUAL_CONSTRAINTS, operand1, operand2, false);
    }

    public static SymbolicValue createNotEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(NOT_EQUAL_CONSTRAINTS, operand1, operand2, true);
    }

    public static SymbolicValue createStrictEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(STRICT_EQUAL_CONSTRAINTS, operand1, operand2, false);
    }

    public static SymbolicValue createStrictNotEqual(SymbolicValue operand1, SymbolicValue operand2) {
        return EqualToSymbolicValue.create(STRICT_NOT_EQUAL_CONSTRAINTS, operand1, operand2, true);
    }

    private static SymbolicValue create(Map<SpecialSymbolicValue, Constraint> map, SymbolicValue operand1, SymbolicValue operand2, boolean isLogicalNot) {
        Constraint constraint = map.get(operand1);
        if (constraint != null && operand2 != null) {
            return new EqualToSymbolicValue(operand2, constraint);
        }
        constraint = map.get(operand2);
        if (constraint != null && operand1 != null) {
            return new EqualToSymbolicValue(operand1, constraint);
        }
        SymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.create(operand1, operand2);
        if (typeOfComparison != null) {
            if (isLogicalNot) {
                typeOfComparison = LogicalNotSymbolicValue.create(typeOfComparison);
            }
            return typeOfComparison;
        }
        return new SymbolicValueWithConstraint(Constraint.BOOLEAN);
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        ProgramState newState = state.constrainOwnSV(this, constraint);
        if (newState == null) {
            return ImmutableList.of();
        }
        if (constraint.equals(Constraint.TRUTHY)) {
            return this.firstOperandValue.constrain(newState, this.secondOperandConstraint);
        }
        if (constraint.equals(Constraint.FALSY)) {
            return this.firstOperandValue.constrain(newState, this.secondOperandConstraint.not());
        }
        return ImmutableList.of();
    }

    @Override
    public Constraint constraint(ProgramState state) {
        return Constraint.BOOLEAN;
    }

    public String toString() {
        return this.firstOperandValue + " === " + this.secondOperandConstraint;
    }

    public boolean equalToSV(Object obj) {
        if (obj instanceof EqualToSymbolicValue) {
            EqualToSymbolicValue other = (EqualToSymbolicValue)obj;
            return Objects.equals(this.firstOperandValue, other.firstOperandValue) && Objects.equals(this.secondOperandConstraint, other.secondOperandConstraint);
        }
        return false;
    }
}

