/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LiteralSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.TypeOfSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class TypeOfComparisonSymbolicValue
implements SymbolicValue {
    private final TypeOfSymbolicValue typeOfOperand;
    private final String comparedTypeString;
    private static final Map<String, Constraint> TYPEOF_EQUAL_CONSTRAINTS = ImmutableMap.builder().put((Object)"undefined", (Object)Constraint.UNDEFINED).put((Object)"function", (Object)Constraint.FUNCTION).put((Object)"object", (Object)Constraint.NULL.or(Constraint.OTHER_OBJECT).or(Constraint.ARRAY)).put((Object)"number", (Object)Constraint.NUMBER).put((Object)"string", (Object)Constraint.STRING).put((Object)"boolean", (Object)Constraint.BOOLEAN).put((Object)"symbol", (Object)Constraint.OTHER_OBJECT).build();

    @CheckForNull
    public static TypeOfComparisonSymbolicValue create(SymbolicValue operand1, SymbolicValue operand2) {
        TypeOfComparisonSymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand1, operand2);
        if (typeOfComparison == null) {
            typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand2, operand1);
        }
        return typeOfComparison;
    }

    @CheckForNull
    private static TypeOfComparisonSymbolicValue createTypeOfComparison(SymbolicValue operand1, SymbolicValue operand2) {
        LiteralTree literal;
        if (operand1 instanceof TypeOfSymbolicValue && operand2 instanceof LiteralSymbolicValue && (literal = ((LiteralSymbolicValue)operand2).getLiteral()).is(Tree.Kind.STRING_LITERAL)) {
            return new TypeOfComparisonSymbolicValue((TypeOfSymbolicValue)operand1, literal.value().substring(1, literal.value().length() - 1));
        }
        return null;
    }

    private TypeOfComparisonSymbolicValue(TypeOfSymbolicValue typeOfOperand, String comparedTypeString) {
        Preconditions.checkArgument((typeOfOperand != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        Preconditions.checkArgument((comparedTypeString != null ? 1 : 0) != 0, (Object)"comparedTypeString should not be null");
        this.typeOfOperand = typeOfOperand;
        this.comparedTypeString = comparedTypeString;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        ProgramState newState = state.constrainOwnSV(this, constraint);
        if (newState == null) {
            return ImmutableList.of();
        }
        Constraint truthyConstraint = TYPEOF_EQUAL_CONSTRAINTS.get(this.comparedTypeString);
        if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return truthyConstraint != null ? this.typeOfOperand.operandValue().constrain(newState, truthyConstraint) : ImmutableList.of();
        }
        if (constraint.isStricterOrEqualTo(Constraint.FALSY) && truthyConstraint != null) {
            return this.typeOfOperand.operandValue().constrain(newState, truthyConstraint.not());
        }
        return ImmutableList.of((Object)newState);
    }

    public String toString() {
        return this.typeOfOperand + " == '" + this.comparedTypeString + "'";
    }
}

