/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class TypeOfSymbolicValue
implements SymbolicValue {
    private final SymbolicValue operandValue;

    public TypeOfSymbolicValue(SymbolicValue operandValue) {
        Preconditions.checkArgument((operandValue != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        this.operandValue = operandValue;
    }

    public SymbolicValue operandValue() {
        return this.operandValue;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        ProgramState newState = state.constrainOwnSV(this, constraint);
        if (newState == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)newState);
    }

    @Override
    public Constraint constraint(ProgramState state) {
        return Constraint.STRING;
    }

    public String toString() {
        return "typeof " + this.operandValue;
    }
}

