/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.RelationalSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;

public class EqualitySymbolicValue
extends RelationalSymbolicValue {
    private static final Set<Tree.Kind> STRICT_EQUALITY_KINDS = EnumSet.of(Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    protected static final Set<Tree.Kind> NEGATION_KINDS = EnumSet.of(Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    private final Tree.Kind kind;
    private final SymbolicValue leftOperand;
    private final SymbolicValue rightOperand;

    EqualitySymbolicValue(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        super(kind, leftOperand, rightOperand);
        this.kind = kind;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    @Override
    public List<ProgramState> constrain(ProgramState incomingState, Constraint constraint) {
        List<ProgramState> constrainedStates = super.constrain(incomingState, constraint);
        constrainedStates = this.constrainOperand(this.leftOperand, this.rightOperand, constraint, constrainedStates);
        constrainedStates = this.constrainOperand(this.rightOperand, this.leftOperand, constraint, constrainedStates);
        return constrainedStates;
    }

    private List<ProgramState> constrainOperand(SymbolicValue sending, SymbolicValue receiving, Constraint constraint, List<ProgramState> incomingStates) {
        ArrayList<ProgramState> constrainedStates = new ArrayList<ProgramState>();
        for (ProgramState state : incomingStates) {
            constrainedStates.addAll(this.constrainOperand(sending, receiving, state, constraint));
        }
        return constrainedStates;
    }

    private List<ProgramState> constrainOperand(SymbolicValue sending, SymbolicValue receiving, ProgramState state, Constraint constraint) {
        Constraint constraintOnSending = state.getConstraint(sending);
        if (constraintOnSending.isStricterOrEqualTo(Constraint.NULL_OR_UNDEFINED)) {
            if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
                return receiving.constrain(state, this.constraintOnNullOrUndefined(constraintOnSending));
            }
            if (constraint.isStricterOrEqualTo(Constraint.FALSY)) {
                return receiving.constrain(state, this.constraintOnNullOrUndefined(constraintOnSending).not());
            }
        }
        return ImmutableList.of((Object)state);
    }

    private Constraint constraintOnNullOrUndefined(Constraint constraintOnSending) {
        Constraint constraint = Constraint.NULL_OR_UNDEFINED;
        if (STRICT_EQUALITY_KINDS.contains((Object)this.kind)) {
            constraint = constraintOnSending;
        }
        return NEGATION_KINDS.contains((Object)this.kind) ? constraint.not() : constraint;
    }

    @Override
    public Constraint constraint(ProgramState state) {
        if (state.getConstraint(this.leftOperand).isIncompatibleWith(state.getConstraint(this.rightOperand))) {
            if (this.kind == Tree.Kind.STRICT_EQUAL_TO) {
                return Constraint.FALSE;
            }
            if (this.kind == Tree.Kind.STRICT_NOT_EQUAL_TO) {
                return Constraint.TRUE;
            }
        }
        return super.constraint(state);
    }
}

