/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class LogicalNotSymbolicValue
implements SymbolicValue {
    private final SymbolicValue negatedValue;

    private LogicalNotSymbolicValue(SymbolicValue negatedValue) {
        Preconditions.checkArgument((negatedValue != null ? 1 : 0) != 0, (Object)"negatedValue should not be null");
        this.negatedValue = negatedValue;
    }

    public static SymbolicValue create(SymbolicValue negatedValue) {
        return new LogicalNotSymbolicValue(negatedValue);
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        ProgramState newState = state.constrainOwnSV(this, constraint);
        if (newState == null) {
            return ImmutableList.of();
        }
        return this.negatedValue.constrain(newState, constraint.not());
    }

    @Override
    public Constraint constraint(ProgramState state) {
        Constraint negatedConstraint = state.getConstraint(this.negatedValue);
        if (negatedConstraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return Constraint.FALSE;
        }
        if (negatedConstraint.isStricterOrEqualTo(Constraint.FALSY)) {
            return Constraint.TRUE;
        }
        return Constraint.BOOLEAN;
    }

    public String toString() {
        return "!" + this.negatedValue;
    }
}

