/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class SymbolicValueWithConstraint
implements SymbolicValue {
    private final Constraint originalConstraint;

    public SymbolicValueWithConstraint(Constraint originalConstraint) {
        this.originalConstraint = originalConstraint;
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        ProgramState newState = state.constrainOwnSV(this, constraint);
        if (newState == null || this.originalConstraint.isIncompatibleWith(constraint)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)newState);
    }

    @Override
    public Constraint constraint(ProgramState state) {
        return this.originalConstraint;
    }

    public String toString() {
        return "SV[" + this.originalConstraint + "]";
    }
}

