/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.lexical;

import com.sonar.sslr.api.TokenType;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class InternalSyntaxToken
extends JavaScriptTree
implements SyntaxToken {
    private List<SyntaxTrivia> trivias;
    private int startIndex;
    private final int line;
    private final int column;
    private final String value;
    private final boolean isEOF;
    private int endLine;
    private int endColumn;

    public InternalSyntaxToken(int line, int column, String value, List<SyntaxTrivia> trivias, int startIndex, boolean isEOF) {
        this.value = value;
        this.line = line;
        this.column = column;
        this.trivias = trivias;
        this.startIndex = startIndex;
        this.isEOF = isEOF;
        this.calculateEndOffsets();
    }

    private void calculateEndOffsets() {
        String[] lines = this.value.split("\r\n|\n|\r", -1);
        this.endColumn = this.column + this.value.length();
        this.endLine = this.line + lines.length - 1;
        if (this.endLine != this.line) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    public int toIndex() {
        return this.startIndex + this.value.length();
    }

    @Override
    public String text() {
        return this.value;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    @Override
    @Deprecated
    public int getLine() {
        return this.line();
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    public int startIndex() {
        return this.startIndex;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TOKEN;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitToken(this);
    }

    public boolean is(TokenType type) {
        return this.text().equals(type.getValue());
    }

    @Override
    public SyntaxToken getFirstToken() {
        return this;
    }

    @Override
    public SyntaxToken getLastToken() {
        return this;
    }
}

