/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class VariableDeclarationTreeImpl
extends JavaScriptTree
implements VariableDeclarationTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken token;
    private final SeparatedList<BindingElementTree> variables;

    public VariableDeclarationTreeImpl(Tree.Kind kind, InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        this.kind = kind;
        this.token = token;
        this.variables = variables;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken token() {
        return this.token;
    }

    @Override
    public SeparatedList<BindingElementTree> variables() {
        return this.variables;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.token), this.variables.elementsAndSeparators((Function<BindingElementTree, Tree>)Functions.identity()));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitVariableDeclaration(this);
    }

    public List<IdentifierTree> variableIdentifiers() {
        ArrayList identifiers = Lists.newArrayList();
        for (Tree tree : this.variables) {
            if (tree.is(Tree.Kind.BINDING_IDENTIFIER)) {
                identifiers.add((IdentifierTree)tree);
                continue;
            }
            if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                identifiers.addAll(((InitializedBindingElementTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            if (tree.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
                identifiers.addAll(((ObjectBindingPatternTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            identifiers.addAll(((ArrayBindingPatternTreeImpl)tree).bindingIdentifiers());
        }
        return identifiers;
    }
}

