/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.type.PrimitiveType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;

public class PrimitiveOperations {
    private static Map<OperationKey, Type> binaryOperationsResults = new HashMap<OperationKey, Type>();
    private static final EnumSet<Tree.Kind> COMPARATIVE_OPERATORS;
    private static final EnumSet<Tree.Kind> ARITHMETIC_OPERATORS;
    private static final EnumSet<Tree.Kind> NUMBER_UNARY_OPERATORS;

    private PrimitiveOperations() {
    }

    private static void put(Type.Kind leftOperandType, Type.Kind rightOperandType, Tree.Kind operation, Type result) {
        binaryOperationsResults.put(new OperationKey(leftOperandType, rightOperandType, operation), result);
    }

    @Nullable
    static Type getType(ExpressionTree leftOperand, ExpressionTree rightOperand, Tree.Kind operationKind) {
        if (COMPARATIVE_OPERATORS.contains((Object)operationKind)) {
            return PrimitiveType.BOOLEAN;
        }
        if (ARITHMETIC_OPERATORS.contains((Object)operationKind)) {
            return PrimitiveType.NUMBER;
        }
        return PrimitiveOperations.getType(leftOperand.types().getUniqueKnownType(), rightOperand.types().getUniqueKnownType(), operationKind);
    }

    @Nullable
    static Type getType(UnaryExpressionTree expressionTree) {
        Tree.Kind kind = ((JavaScriptTree)((Object)expressionTree)).getKind();
        if (NUMBER_UNARY_OPERATORS.contains((Object)kind)) {
            return PrimitiveType.NUMBER;
        }
        if (expressionTree.is(Tree.Kind.TYPEOF)) {
            return PrimitiveType.STRING;
        }
        if (expressionTree.is(Tree.Kind.DELETE, Tree.Kind.LOGICAL_COMPLEMENT)) {
            return PrimitiveType.BOOLEAN;
        }
        return null;
    }

    @Nullable
    static Type getType(@Nullable Type leftOperandType, @Nullable Type rightOperandType, Tree.Kind operationKind) {
        if (leftOperandType != null && rightOperandType != null) {
            return binaryOperationsResults.get(new OperationKey(leftOperandType.kind(), rightOperandType.kind(), operationKind));
        }
        return null;
    }

    static {
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.PLUS, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.NUMBER, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.STRING, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.PLUS, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.CONDITIONAL_AND, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.CONDITIONAL_AND, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.BOOLEAN, Type.Kind.BOOLEAN, Tree.Kind.CONDITIONAL_AND, PrimitiveType.BOOLEAN);
        PrimitiveOperations.put(Type.Kind.STRING, Type.Kind.STRING, Tree.Kind.CONDITIONAL_OR, PrimitiveType.STRING);
        PrimitiveOperations.put(Type.Kind.NUMBER, Type.Kind.NUMBER, Tree.Kind.CONDITIONAL_OR, PrimitiveType.NUMBER);
        PrimitiveOperations.put(Type.Kind.BOOLEAN, Type.Kind.BOOLEAN, Tree.Kind.CONDITIONAL_OR, PrimitiveType.BOOLEAN);
        COMPARATIVE_OPERATORS = EnumSet.of(Tree.Kind.LESS_THAN, new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO});
        ARITHMETIC_OPERATORS = EnumSet.of(Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER);
        NUMBER_UNARY_OPERATORS = EnumSet.of(Tree.Kind.PREFIX_DECREMENT, new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.BITWISE_COMPLEMENT});
    }

    private static class OperationKey {
        Type.Kind leftOperandType;
        Type.Kind rightOperandType;
        Tree.Kind operation;

        public OperationKey(Type.Kind leftOperandType, Type.Kind rightOperandType, Tree.Kind operation) {
            this.leftOperandType = leftOperandType;
            this.rightOperandType = rightOperandType;
            this.operation = operation;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationKey that = (OperationKey)o;
            return this.leftOperandType == that.leftOperandType && this.rightOperandType == that.rightOperandType && this.operation == that.operation;
        }

        public int hashCode() {
            int result = this.leftOperandType.hashCode();
            result = 31 * result + this.rightOperandType.hashCode();
            result = 31 * result + this.operation.hashCode();
            return result;
        }
    }
}

