/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;

public class LineIssue
implements Issue {
    private JavaScriptCheck check;
    private Double cost;
    private String message;
    private int line;

    public LineIssue(JavaScriptCheck check, int line, String message) {
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        this.check = check;
        this.message = message;
        this.line = line;
        this.cost = null;
    }

    public LineIssue(JavaScriptCheck check, Tree tree, String message) {
        this.check = check;
        this.message = message;
        this.line = ((JavaScriptTree)tree).getLine();
        this.cost = null;
    }

    public String message() {
        return this.message;
    }

    public int line() {
        return this.line;
    }

    @Override
    public JavaScriptCheck check() {
        return this.check;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public Issue cost(double cost) {
        this.cost = cost;
        return this;
    }
}

