/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.declaration.AccessorMethodDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.BindingPropertyTreeImpl;
import org.sonar.javascript.tree.impl.declaration.DecoratorTreeImpl;
import org.sonar.javascript.tree.impl.declaration.DefaultExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ExportClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingWithExportListImpl;
import org.sonar.javascript.tree.impl.declaration.ExportDefaultBindingWithNameSpaceExportImpl;
import org.sonar.javascript.tree.impl.declaration.FieldDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.FromClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.FunctionDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.GeneratorMethodDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportClauseTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ImportModuleDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.tree.impl.declaration.MethodDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ModuleTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NameSpaceExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NameSpaceSpecifierTreeImpl;
import org.sonar.javascript.tree.impl.declaration.NamedExportDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.javascript.tree.impl.declaration.ScriptTreeImpl;
import org.sonar.javascript.tree.impl.declaration.SpecifierListTreeImpl;
import org.sonar.javascript.tree.impl.declaration.SpecifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrayAssignmentPatternTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrayLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.ArrowFunctionTreeImpl;
import org.sonar.javascript.tree.impl.expression.AssignmentExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.AssignmentPatternRestElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.BinaryExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.BracketMemberExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.CallExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.ClassTreeImpl;
import org.sonar.javascript.tree.impl.expression.ComputedPropertyNameTreeImpl;
import org.sonar.javascript.tree.impl.expression.ConditionalExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.DotMemberExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.FunctionExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.IdentifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.InitializedAssignmentPatternElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.LiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.NewExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.NewTargetTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectAssignmentPatternPairElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectAssignmentPatternTreeImpl;
import org.sonar.javascript.tree.impl.expression.ObjectLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.PairPropertyTreeImpl;
import org.sonar.javascript.tree.impl.expression.ParenthesisedExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.PostfixExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.PrefixExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.RestElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.SpreadElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.SuperTreeImpl;
import org.sonar.javascript.tree.impl.expression.TaggedTemplateTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateCharactersTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.TemplateLiteralTreeImpl;
import org.sonar.javascript.tree.impl.expression.YieldExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxClosingElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxIdentifierTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxJavaScriptExpressionTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxOpeningElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxSelfClosingElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxSpreadAttributeTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxStandardAttributeTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxStandardElementTreeImpl;
import org.sonar.javascript.tree.impl.expression.jsx.JsxTextTreeImpl;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.impl.statement.BlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.BreakStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.CaseClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.CatchBlockTreeImpl;
import org.sonar.javascript.tree.impl.statement.ContinueStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.DebuggerStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.DefaultClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.DoWhileStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ElseClauseTreeImpl;
import org.sonar.javascript.tree.impl.statement.EmptyStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ExpressionStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ForObjectStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ForStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.LabelledStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ReturnStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.SwitchStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.ThrowStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.TryStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.tree.impl.statement.VariableStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.WhileStatementTreeImpl;
import org.sonar.javascript.tree.impl.statement.WithStatementTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.DeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.DecoratorTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBinding;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBindingWithExportList;
import org.sonar.plugins.javascript.api.tree.declaration.ExportDefaultBindingWithNameSpaceExport;
import org.sonar.plugins.javascript.api.tree.declaration.FieldDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportModuleDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.InitializedAssignmentPatternElementTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternPairElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectAssignmentPatternTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxAttributeValueTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxChildTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxClosingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxElementNameTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxIdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxJavaScriptExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxOpeningElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSelfClosingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxSpreadAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxStandardAttributeTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxStandardElementTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxTextTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;

public class TreeFactory {
    private static final Map<String, Tree.Kind> EXPRESSION_KIND_BY_VALUE = new HashMap<String, Tree.Kind>();
    private static final Map<String, Tree.Kind> PREFIX_KIND_BY_VALUE;

    private static Tree.Kind getBinaryOperator(InternalSyntaxToken token) {
        Tree.Kind kind = EXPRESSION_KIND_BY_VALUE.get(token.text());
        if (kind == null) {
            throw new IllegalArgumentException("Mapping not found for binary operator " + token.text());
        }
        return kind;
    }

    private static Tree.Kind getPrefixOperator(InternalSyntaxToken token) {
        Tree.Kind kind = PREFIX_KIND_BY_VALUE.get(token.text());
        if (kind == null) {
            throw new IllegalArgumentException("Mapping not found for unary operator " + token.text());
        }
        return kind;
    }

    public EmptyStatementTreeImpl emptyStatement(InternalSyntaxToken semicolon) {
        return new EmptyStatementTreeImpl(semicolon);
    }

    public DebuggerStatementTreeImpl debuggerStatement(InternalSyntaxToken debuggerWord, Tree semicolonToken) {
        return new DebuggerStatementTreeImpl(debuggerWord, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public VariableStatementTreeImpl variableStatement(VariableDeclarationTreeImpl declaration, Tree semicolonToken) {
        return new VariableStatementTreeImpl(declaration, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    private static VariableDeclarationTreeImpl variableDeclaration(InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        Tree.Kind kind;
        if (token.is(JavaScriptKeyword.VAR)) {
            kind = Tree.Kind.VAR_DECLARATION;
        } else if ("let".equals(token.text())) {
            kind = Tree.Kind.LET_DECLARATION;
        } else if (token.is(JavaScriptKeyword.CONST)) {
            kind = Tree.Kind.CONST_DECLARATION;
        } else {
            throw new UnsupportedOperationException("Unsupported token, " + token.text());
        }
        return new VariableDeclarationTreeImpl(kind, token, variables);
    }

    public VariableDeclarationTreeImpl variableDeclaration1(InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        return TreeFactory.variableDeclaration(token, variables);
    }

    public VariableDeclarationTreeImpl variableDeclaration2(InternalSyntaxToken token, SeparatedList<BindingElementTree> variables) {
        return TreeFactory.variableDeclaration(token, variables);
    }

    private static SeparatedList<BindingElementTree> bindingElementList(BindingElementTree element, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> rest) {
        ImmutableList.Builder elements = ImmutableList.builder();
        ImmutableList.Builder commas = ImmutableList.builder();
        elements.add((Object)element);
        if (rest.isPresent()) {
            for (Tuple pair : (List)rest.get()) {
                InternalSyntaxToken commaToken = (InternalSyntaxToken)pair.first();
                commas.add((Object)commaToken);
                elements.add(pair.second());
            }
        }
        return new SeparatedList<BindingElementTree>((List<BindingElementTree>)elements.build(), (List<InternalSyntaxToken>)commas.build());
    }

    public SeparatedList<BindingElementTree> bindingElementList1(BindingElementTree element, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> rest) {
        return TreeFactory.bindingElementList(element, rest);
    }

    public SeparatedList<BindingElementTree> bindingElementList2(BindingElementTree element, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> rest) {
        return TreeFactory.bindingElementList(element, rest);
    }

    public LabelledStatementTreeImpl labelledStatement(IdentifierTreeImpl identifier, InternalSyntaxToken colon, StatementTree statement) {
        return new LabelledStatementTreeImpl(identifier, colon, statement);
    }

    public ContinueStatementTreeImpl completeContinueStatement(InternalSyntaxToken continueToken, ContinueStatementTreeImpl labelOrEndOfStatement) {
        return labelOrEndOfStatement.complete(continueToken);
    }

    public ContinueStatementTreeImpl newContinueWithLabel(IdentifierTreeImpl identifier, Tree semicolonToken) {
        return new ContinueStatementTreeImpl(identifier, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ContinueStatementTreeImpl newContinueWithoutLabel(Tree semicolonToken) {
        return new ContinueStatementTreeImpl(TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public BreakStatementTreeImpl completeBreakStatement(InternalSyntaxToken breakToken, BreakStatementTreeImpl labelOrEndOfStatement) {
        return labelOrEndOfStatement.complete(breakToken);
    }

    public BreakStatementTreeImpl newBreakWithLabel(IdentifierTreeImpl identifier, Tree semicolonToken) {
        return new BreakStatementTreeImpl(identifier, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public BreakStatementTreeImpl newBreakWithoutLabel(Tree semicolonToken) {
        return new BreakStatementTreeImpl(TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ReturnStatementTreeImpl completeReturnStatement(InternalSyntaxToken returnToken, ReturnStatementTreeImpl expressionOrEndOfStatement) {
        return expressionOrEndOfStatement.complete(returnToken);
    }

    public ReturnStatementTreeImpl newReturnWithExpression(ExpressionTree expression, Tree semicolonToken) {
        return new ReturnStatementTreeImpl(expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ReturnStatementTreeImpl newReturnWithoutExpression(Tree semicolonToken) {
        return new ReturnStatementTreeImpl(TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ThrowStatementTreeImpl newThrowStatement(InternalSyntaxToken throwToken, ExpressionTree expression, Tree semicolonToken) {
        return new ThrowStatementTreeImpl(throwToken, expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public WithStatementTreeImpl newWithStatement(InternalSyntaxToken withToken, InternalSyntaxToken openingParen, ExpressionTree expression, InternalSyntaxToken closingParen, StatementTree statement) {
        return new WithStatementTreeImpl(withToken, openingParen, expression, closingParen, statement);
    }

    public BlockTreeImpl newBlock(InternalSyntaxToken openingCurlyBrace, Optional<List<StatementTree>> statements, InternalSyntaxToken closingCurlyBrace) {
        if (statements.isPresent()) {
            return new BlockTreeImpl(openingCurlyBrace, (List)statements.get(), closingCurlyBrace);
        }
        return new BlockTreeImpl(openingCurlyBrace, closingCurlyBrace);
    }

    public TryStatementTreeImpl newTryStatementWithCatch(CatchBlockTreeImpl catchBlock, Optional<TryStatementTreeImpl> partial) {
        if (partial.isPresent()) {
            return ((TryStatementTreeImpl)partial.get()).complete(catchBlock);
        }
        return new TryStatementTreeImpl(catchBlock);
    }

    public TryStatementTreeImpl newTryStatementWithFinally(InternalSyntaxToken finallyKeyword, BlockTreeImpl block) {
        return new TryStatementTreeImpl(finallyKeyword, block);
    }

    public TryStatementTreeImpl completeTryStatement(InternalSyntaxToken tryToken, BlockTreeImpl block, TryStatementTreeImpl catchFinallyBlock) {
        return catchFinallyBlock.complete(tryToken, block);
    }

    public CatchBlockTreeImpl newCatchBlock(InternalSyntaxToken catchToken, InternalSyntaxToken lparenToken, BindingElementTree catchParameter, InternalSyntaxToken rparenToken, BlockTreeImpl block) {
        return new CatchBlockTreeImpl(catchToken, lparenToken, catchParameter, rparenToken, block);
    }

    public SwitchStatementTreeImpl newSwitchStatement(InternalSyntaxToken openCurlyBrace, Optional<List<CaseClauseTreeImpl>> caseClauseList, Optional<Tuple<DefaultClauseTreeImpl, Optional<List<CaseClauseTreeImpl>>>> defaultAndRestCases, InternalSyntaxToken closeCurlyBrace) {
        ArrayList cases = Lists.newArrayList();
        if (caseClauseList.isPresent()) {
            cases.addAll((Collection)caseClauseList.get());
        }
        if (defaultAndRestCases.isPresent()) {
            cases.add(((Tuple)defaultAndRestCases.get()).first());
            if (((Optional)((Tuple)defaultAndRestCases.get()).second()).isPresent()) {
                cases.addAll((Collection)((Optional)((Tuple)defaultAndRestCases.get()).second()).get());
            }
        }
        return new SwitchStatementTreeImpl(openCurlyBrace, cases, closeCurlyBrace);
    }

    public SwitchStatementTreeImpl completeSwitchStatement(InternalSyntaxToken switchToken, InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis, SwitchStatementTreeImpl caseBlock) {
        return caseBlock.complete(switchToken, openParenthesis, expression, closeParenthesis);
    }

    public DefaultClauseTreeImpl defaultClause(InternalSyntaxToken defaultToken, InternalSyntaxToken colonToken, Optional<List<StatementTree>> statements) {
        if (statements.isPresent()) {
            return new DefaultClauseTreeImpl(defaultToken, colonToken, (List)statements.get());
        }
        return new DefaultClauseTreeImpl(defaultToken, colonToken);
    }

    public CaseClauseTreeImpl caseClause(InternalSyntaxToken caseToken, ExpressionTree expression, InternalSyntaxToken colonToken, Optional<List<StatementTree>> statements) {
        if (statements.isPresent()) {
            return new CaseClauseTreeImpl(caseToken, expression, colonToken, (List)statements.get());
        }
        return new CaseClauseTreeImpl(caseToken, expression, colonToken);
    }

    public ElseClauseTreeImpl elseClause(InternalSyntaxToken elseToken, StatementTree statement) {
        return new ElseClauseTreeImpl(elseToken, statement);
    }

    public IfStatementTreeImpl ifStatement(InternalSyntaxToken ifToken, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree statement, Optional<ElseClauseTreeImpl> elseClause) {
        if (elseClause.isPresent()) {
            return new IfStatementTreeImpl(ifToken, openParenToken, condition, closeParenToken, statement, (ElseClauseTreeImpl)elseClause.get());
        }
        return new IfStatementTreeImpl(ifToken, openParenToken, condition, closeParenToken, statement);
    }

    public WhileStatementTreeImpl whileStatement(InternalSyntaxToken whileToken, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, StatementTree statetment) {
        return new WhileStatementTreeImpl(whileToken, openParenthesis, condition, closeParenthesis, statetment);
    }

    public DoWhileStatementTreeImpl doWhileStatement(InternalSyntaxToken doToken, StatementTree statement, InternalSyntaxToken whileToken, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, Tree semicolonToken) {
        return new DoWhileStatementTreeImpl(doToken, statement, whileToken, openParenthesis, condition, closeParenthesis, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExpressionStatementTreeImpl expressionStatement(Tree lookahead, ExpressionTree expression, Tree semicolonToken) {
        return new ExpressionStatementTreeImpl(expression, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    @Nullable
    private static InternalSyntaxToken nullableSemicolonToken(Tree semicolonToken) {
        if (semicolonToken instanceof InternalSyntaxToken) {
            return (InternalSyntaxToken)semicolonToken;
        }
        return null;
    }

    public ForObjectStatementTreeImpl forOfStatement(InternalSyntaxToken forToken, InternalSyntaxToken openParenthesis, Tree variableOrExpression, InternalSyntaxToken ofToken, ExpressionTree expression, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForObjectStatementTreeImpl(forToken, openParenthesis, variableOrExpression, ofToken, expression, closeParenthesis, statement);
    }

    public ForObjectStatementTreeImpl forInStatement(InternalSyntaxToken forToken, InternalSyntaxToken openParenthesis, Tree variableOrExpression, InternalSyntaxToken inToken, ExpressionTree expression, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForObjectStatementTreeImpl(forToken, openParenthesis, variableOrExpression, inToken, expression, closeParenthesis, statement);
    }

    public ForStatementTreeImpl forStatement(InternalSyntaxToken forToken, InternalSyntaxToken openParenthesis, Optional<Tree> init, InternalSyntaxToken firstSemiToken, Optional<ExpressionTree> condition, InternalSyntaxToken secondSemiToken, Optional<ExpressionTree> update, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        return new ForStatementTreeImpl(forToken, openParenthesis, (Tree)init.orNull(), firstSemiToken, (ExpressionTree)condition.orNull(), secondSemiToken, (ExpressionTree)update.orNull(), closeParenthesis, statement);
    }

    public ArrayLiteralTreeImpl newArrayLiteralWithElements(Optional<List<InternalSyntaxToken>> commaTokens, ExpressionTree element, Optional<List<Tuple<List<InternalSyntaxToken>, ExpressionTree>>> restElements, Optional<List<InternalSyntaxToken>> restCommas) {
        ArrayList elementsAndCommas = Lists.newArrayList();
        if (commaTokens.isPresent()) {
            elementsAndCommas.addAll((Collection)commaTokens.get());
        }
        elementsAndCommas.add(element);
        if (restElements.isPresent()) {
            for (Tuple t : (List)restElements.get()) {
                elementsAndCommas.addAll((Collection)t.first());
                elementsAndCommas.add(t.second());
            }
        }
        if (restCommas.isPresent()) {
            elementsAndCommas.addAll((Collection)restCommas.get());
        }
        return new ArrayLiteralTreeImpl(elementsAndCommas);
    }

    public ArrayLiteralTreeImpl completeArrayLiteral(InternalSyntaxToken openBracketToken, Optional<ArrayLiteralTreeImpl> elements, InternalSyntaxToken closeBracket) {
        if (elements.isPresent()) {
            return ((ArrayLiteralTreeImpl)elements.get()).complete(openBracketToken, closeBracket);
        }
        return new ArrayLiteralTreeImpl(openBracketToken, closeBracket);
    }

    public ArrayLiteralTreeImpl newArrayLiteralWithElidedElements(List<InternalSyntaxToken> commaTokens) {
        return new ArrayLiteralTreeImpl(new ArrayList<Tree>(commaTokens));
    }

    public FunctionExpressionTree generatorExpression(InternalSyntaxToken functionKeyword, InternalSyntaxToken starOperator, Optional<IdentifierTreeImpl> functionName, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return FunctionExpressionTreeImpl.createGenerator(functionKeyword, starOperator, (IdentifierTree)functionName.orNull(), parameters, body);
    }

    public LiteralTreeImpl nullLiteral(InternalSyntaxToken nullToken) {
        return new LiteralTreeImpl(Tree.Kind.NULL_LITERAL, nullToken);
    }

    public LiteralTreeImpl booleanLiteral(InternalSyntaxToken trueFalseToken) {
        return new LiteralTreeImpl(Tree.Kind.BOOLEAN_LITERAL, trueFalseToken);
    }

    public LiteralTreeImpl numericLiteral(InternalSyntaxToken numericToken) {
        return new LiteralTreeImpl(Tree.Kind.NUMERIC_LITERAL, numericToken);
    }

    public LiteralTreeImpl stringLiteral(InternalSyntaxToken stringToken) {
        return new LiteralTreeImpl(Tree.Kind.STRING_LITERAL, stringToken);
    }

    public LiteralTreeImpl regexpLiteral(InternalSyntaxToken regexpToken) {
        return new LiteralTreeImpl(Tree.Kind.REGULAR_EXPRESSION_LITERAL, regexpToken);
    }

    public FunctionExpressionTree functionExpression(Optional<InternalSyntaxToken> asyncToken, InternalSyntaxToken functionKeyword, Optional<IdentifierTree> functionName, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return FunctionExpressionTreeImpl.create((SyntaxToken)asyncToken.orNull(), functionKeyword, (IdentifierTree)functionName.orNull(), parameters, body);
    }

    public SeparatedList<Tree> formalParameters(BindingElementTree formalParameter, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> formalParameters) {
        ArrayList parameters = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        parameters.add(formalParameter);
        if (formalParameters.isPresent()) {
            for (Tuple t : (List)formalParameters.get()) {
                commas.add(t.first());
                parameters.add(t.second());
            }
        }
        return new SeparatedList<Tree>(parameters, commas);
    }

    public ParameterListTreeImpl formalParameterClause1(InternalSyntaxToken lParenthesis, SeparatedList<Tree> parameters, Optional<InternalSyntaxToken> trailingComma, InternalSyntaxToken rParenthesis) {
        if (trailingComma.isPresent()) {
            parameters.getSeparators().add((InternalSyntaxToken)trailingComma.get());
        }
        return new ParameterListTreeImpl(Tree.Kind.FORMAL_PARAMETER_LIST, lParenthesis, parameters, rParenthesis);
    }

    public ParameterListTreeImpl formalParameterClause2(InternalSyntaxToken lParenthesis, SeparatedList<Tree> parameters, InternalSyntaxToken comma, RestElementTreeImpl restElementTree, InternalSyntaxToken rParenthesis) {
        parameters.getSeparators().add(comma);
        parameters.add(restElementTree);
        return new ParameterListTreeImpl(Tree.Kind.FORMAL_PARAMETER_LIST, lParenthesis, parameters, rParenthesis);
    }

    public ParameterListTreeImpl formalParameterClause3(InternalSyntaxToken lParenthesis, Optional<RestElementTreeImpl> restElementTree, InternalSyntaxToken rParenthesis) {
        SeparatedList<Tree> parameters = new SeparatedList<Tree>(Lists.newArrayList(), Collections.emptyList());
        if (restElementTree.isPresent()) {
            parameters.add((Tree)restElementTree.get());
        }
        return new ParameterListTreeImpl(Tree.Kind.FORMAL_PARAMETER_LIST, lParenthesis, parameters, rParenthesis);
    }

    public RestElementTreeImpl bindingRestElement(InternalSyntaxToken ellipsis, IdentifierTreeImpl identifier) {
        return new RestElementTreeImpl(ellipsis, identifier);
    }

    public ConditionalExpressionTreeImpl newConditionalExpression(InternalSyntaxToken queryToken, ExpressionTree trueExpression, InternalSyntaxToken colonToken, ExpressionTree falseExpression) {
        return new ConditionalExpressionTreeImpl(queryToken, trueExpression, colonToken, falseExpression);
    }

    public ConditionalExpressionTreeImpl newConditionalExpressionNoIn(InternalSyntaxToken queryToken, ExpressionTree trueExpression, InternalSyntaxToken colonToken, ExpressionTree falseExpression) {
        return new ConditionalExpressionTreeImpl(queryToken, trueExpression, colonToken, falseExpression);
    }

    public ExpressionTree completeConditionalExpression(ExpressionTree expression, Optional<ConditionalExpressionTreeImpl> partial) {
        return partial.isPresent() ? ((ConditionalExpressionTreeImpl)partial.get()).complete(expression) : expression;
    }

    public ExpressionTree completeConditionalExpressionNoIn(ExpressionTree expression, Optional<ConditionalExpressionTreeImpl> partial) {
        return partial.isPresent() ? ((ConditionalExpressionTreeImpl)partial.get()).complete(expression) : expression;
    }

    public ExpressionTree newConditionalOr(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newConditionalOrNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newConditionalAnd(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newConditionalAndNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseOr(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseOrNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseXor(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseXorNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseAnd(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newBitwiseAndNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newEquality(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newEqualityNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newRelational(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newRelationalNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newShift(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newAdditive(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newMultiplicative(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree newExponentiation(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        List list = (List)operatorAndOperands.get();
        ExpressionTree result = (ExpressionTree)((Tuple)list.get(list.size() - 1)).second;
        for (int i = list.size() - 1; i > 0; --i) {
            result = new BinaryExpressionTreeImpl(Tree.Kind.EXPONENT, (ExpressionTree)((Tuple)list.get(i - 1)).second, (InternalSyntaxToken)((Tuple)list.get(i)).first, result);
        }
        return new BinaryExpressionTreeImpl(Tree.Kind.EXPONENT, expression, (InternalSyntaxToken)((Tuple)list.get(0)).first, result);
    }

    private static ExpressionTree buildBinaryExpression(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = expression;
        for (Tuple t : (List)operatorAndOperands.get()) {
            result = new BinaryExpressionTreeImpl(TreeFactory.getBinaryOperator((InternalSyntaxToken)t.first()), result, (InternalSyntaxToken)t.first(), (ExpressionTree)t.second());
        }
        return result;
    }

    public ExpressionTree prefixExpression(InternalSyntaxToken operator, ExpressionTree expression) {
        return new PrefixExpressionTreeImpl(TreeFactory.getPrefixOperator(operator), operator, expression);
    }

    public ExpressionTree postfixExpression(ExpressionTree expression, Optional<Tuple<InternalSyntaxToken, InternalSyntaxToken>> operatorNoLB) {
        if (!operatorNoLB.isPresent()) {
            return expression;
        }
        Tree.Kind kind = ((InternalSyntaxToken)((Tuple)operatorNoLB.get()).second()).is(JavaScriptPunctuator.INC) ? Tree.Kind.POSTFIX_INCREMENT : Tree.Kind.POSTFIX_DECREMENT;
        return new PostfixExpressionTreeImpl(kind, expression, (InternalSyntaxToken)((Tuple)operatorNoLB.get()).second());
    }

    public YieldExpressionTreeImpl completeYieldExpression(InternalSyntaxToken yieldToken, Optional<YieldExpressionTreeImpl> partial) {
        if (partial.isPresent()) {
            return ((YieldExpressionTreeImpl)partial.get()).complete(yieldToken);
        }
        return new YieldExpressionTreeImpl(yieldToken);
    }

    public YieldExpressionTreeImpl completeYieldExpressionNoIn(InternalSyntaxToken yieldToken, Optional<YieldExpressionTreeImpl> partial) {
        if (partial.isPresent()) {
            return ((YieldExpressionTreeImpl)partial.get()).complete(yieldToken);
        }
        return new YieldExpressionTreeImpl(yieldToken);
    }

    public YieldExpressionTreeImpl newYieldExpression(Tree spacingNoLB, Optional<InternalSyntaxToken> starToken, ExpressionTree expression) {
        if (starToken.isPresent()) {
            return new YieldExpressionTreeImpl((InternalSyntaxToken)starToken.get(), expression);
        }
        return new YieldExpressionTreeImpl(expression);
    }

    public YieldExpressionTreeImpl newYieldExpressionNoIn(Tree spacingNoLB, Optional<InternalSyntaxToken> starToken, ExpressionTree expression) {
        if (starToken.isPresent()) {
            return new YieldExpressionTreeImpl((InternalSyntaxToken)starToken.get(), expression);
        }
        return new YieldExpressionTreeImpl(expression);
    }

    public IdentifierTreeImpl identifierReference(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.IDENTIFIER_REFERENCE, identifier);
    }

    public IdentifierTreeImpl bindingIdentifier(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.BINDING_IDENTIFIER, identifier);
    }

    public ArrowFunctionTreeImpl arrowFunction(Optional<InternalSyntaxToken> asyncToken, Tree parameters, Tree spacingNoLB, InternalSyntaxToken doubleArrow, Tree body) {
        return new ArrowFunctionTreeImpl((SyntaxToken)asyncToken.orNull(), parameters, doubleArrow, body);
    }

    public ArrowFunctionTreeImpl arrowFunctionNoIn(Optional<InternalSyntaxToken> asyncToken, Tree parameters, Tree spacingNoLB, InternalSyntaxToken doubleArrow, Tree body) {
        return new ArrowFunctionTreeImpl((SyntaxToken)asyncToken.orNull(), parameters, doubleArrow, body);
    }

    public IdentifierTreeImpl identifierName(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.IDENTIFIER_NAME, identifier);
    }

    public DotMemberExpressionTreeImpl newDotMemberExpression(InternalSyntaxToken dotToken, IdentifierTreeImpl identifier) {
        return new DotMemberExpressionTreeImpl(dotToken, identifier);
    }

    public BracketMemberExpressionTreeImpl newBracketMemberExpression(InternalSyntaxToken openBracket, ExpressionTree expression, InternalSyntaxToken closeBracket) {
        return new BracketMemberExpressionTreeImpl(openBracket, expression, closeBracket);
    }

    public MemberExpressionTree completeSuperMemberExpression(SuperTreeImpl superExpression, MemberExpressionTree partial) {
        if (partial.is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
            return ((DotMemberExpressionTreeImpl)partial).complete(superExpression);
        }
        return ((BracketMemberExpressionTreeImpl)partial).complete(superExpression);
    }

    public SuperTreeImpl superExpression(InternalSyntaxToken superToken) {
        return new SuperTreeImpl(superToken);
    }

    public NewTargetTreeImpl newTarget(SyntaxToken newKeyword, SyntaxToken dot, SyntaxToken target) {
        return new NewTargetTreeImpl(newKeyword, dot, target);
    }

    public TaggedTemplateTreeImpl newTaggedTemplate(TemplateLiteralTree template) {
        return new TaggedTemplateTreeImpl(template);
    }

    public ExpressionTree completeMemberExpression(ExpressionTree object, Optional<List<ExpressionTree>> properties) {
        if (!properties.isPresent()) {
            return object;
        }
        ExpressionTree result = object;
        for (ExpressionTree property : (List)properties.get()) {
            if (property.is(Tree.Kind.DOT_MEMBER_EXPRESSION)) {
                result = ((DotMemberExpressionTreeImpl)property).complete(result);
                continue;
            }
            if (property.is(Tree.Kind.BRACKET_MEMBER_EXPRESSION)) {
                result = ((BracketMemberExpressionTreeImpl)property).complete(result);
                continue;
            }
            result = ((TaggedTemplateTreeImpl)property).complete(result);
        }
        return result;
    }

    public SeparatedList<Tree> argumentList(ExpressionTree argument, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> restArguments, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList arguments = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        arguments.add(argument);
        if (restArguments.isPresent()) {
            for (Tuple t : (List)restArguments.get()) {
                commas.add(t.first());
                arguments.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SeparatedList<Tree>(arguments, commas);
    }

    public ParameterListTreeImpl argumentClause(InternalSyntaxToken openParenToken, Optional<SeparatedList<Tree>> arguments, InternalSyntaxToken closeParenToken) {
        return new ParameterListTreeImpl(Tree.Kind.ARGUMENTS, openParenToken, arguments.isPresent() ? (SeparatedList)arguments.get() : new SeparatedList<Tree>(Collections.emptyList(), Collections.emptyList()), closeParenToken);
    }

    public CallExpressionTreeImpl simpleCallExpression(ExpressionTree expression, ParameterListTree arguments) {
        return new CallExpressionTreeImpl(expression, arguments);
    }

    public ExpressionTree callExpression(CallExpressionTreeImpl callExpression, Optional<List<ExpressionTree>> arguments) {
        if (!arguments.isPresent()) {
            return callExpression;
        }
        JavaScriptTree callee = callExpression;
        for (ExpressionTree arg : (List)arguments.get()) {
            if (arg instanceof BracketMemberExpressionTree) {
                callee = ((BracketMemberExpressionTreeImpl)arg).complete((ExpressionTree)((Object)callee));
                continue;
            }
            if (arg instanceof DotMemberExpressionTreeImpl) {
                callee = ((DotMemberExpressionTreeImpl)arg).complete((ExpressionTree)((Object)callee));
                continue;
            }
            if (arg instanceof TaggedTemplateTreeImpl) {
                callee = ((TaggedTemplateTreeImpl)arg).complete((ExpressionTree)((Object)callee));
                continue;
            }
            callee = new CallExpressionTreeImpl((ExpressionTree)((Object)callee), (ParameterListTreeImpl)arg);
        }
        return callee;
    }

    public ParenthesisedExpressionTreeImpl parenthesisedExpression(InternalSyntaxToken openParenToken, ExpressionTree expression, InternalSyntaxToken closeParenToken) {
        return new ParenthesisedExpressionTreeImpl(openParenToken, expression, closeParenToken);
    }

    public ClassTreeImpl classExpression(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken classToken, Optional<IdentifierTreeImpl> name, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> extendsClause, InternalSyntaxToken openCurlyBraceToken, Optional<List<Tree>> members, InternalSyntaxToken closeCurlyBraceToken) {
        ArrayList elements = Lists.newArrayList();
        if (members.isPresent()) {
            for (Tree member : (List)members.get()) {
                elements.add(member);
            }
        }
        if (extendsClause.isPresent()) {
            return ClassTreeImpl.newClassExpression(TreeFactory.optionalList(decorators), classToken, (IdentifierTreeImpl)name.orNull(), (InternalSyntaxToken)((Tuple)extendsClause.get()).first(), (ExpressionTree)((Tuple)extendsClause.get()).second(), openCurlyBraceToken, elements, closeCurlyBraceToken);
        }
        return ClassTreeImpl.newClassExpression(TreeFactory.optionalList(decorators), classToken, (IdentifierTreeImpl)name.orNull(), null, null, openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    public ComputedPropertyNameTreeImpl computedPropertyName(InternalSyntaxToken openBracketToken, ExpressionTree expression, InternalSyntaxToken closeBracketToken) {
        return new ComputedPropertyNameTreeImpl(openBracketToken, expression, closeBracketToken);
    }

    public PairPropertyTreeImpl pairProperty(Tree name, InternalSyntaxToken colonToken, ExpressionTree value) {
        return new PairPropertyTreeImpl(name, colonToken, value);
    }

    public SpreadElementTreeImpl spreadElement(InternalSyntaxToken ellipsis, ExpressionTree expression) {
        return new SpreadElementTreeImpl(ellipsis, expression);
    }

    public ObjectLiteralTreeImpl newObjectLiteral(Tree property, Optional<List<Tuple<InternalSyntaxToken, Tree>>> restProperties, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList properties = Lists.newArrayList();
        properties.add(property);
        if (restProperties.isPresent()) {
            for (Tuple t : (List)restProperties.get()) {
                commas.add(t.first());
                properties.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new ObjectLiteralTreeImpl(new SeparatedList<Tree>(properties, commas));
    }

    public ObjectLiteralTreeImpl completeObjectLiteral(InternalSyntaxToken openCurlyToken, Optional<ObjectLiteralTreeImpl> partial, InternalSyntaxToken closeCurlyToken) {
        if (partial.isPresent()) {
            return ((ObjectLiteralTreeImpl)partial.get()).complete(openCurlyToken, closeCurlyToken);
        }
        return new ObjectLiteralTreeImpl(openCurlyToken, closeCurlyToken);
    }

    public NewExpressionTreeImpl newExpressionWithArgument(InternalSyntaxToken newToken, ExpressionTree expression, ParameterListTreeImpl arguments) {
        return new NewExpressionTreeImpl(expression.is(Tree.Kind.SUPER) ? Tree.Kind.NEW_SUPER : Tree.Kind.NEW_EXPRESSION, newToken, expression, arguments);
    }

    public ExpressionTree newExpression(InternalSyntaxToken newToken, ExpressionTree expression) {
        return new NewExpressionTreeImpl(expression.is(Tree.Kind.SUPER) ? Tree.Kind.NEW_SUPER : Tree.Kind.NEW_EXPRESSION, newToken, expression);
    }

    public TemplateLiteralTree noSubstitutionTemplate(InternalSyntaxToken openBacktickToken, Optional<TemplateCharactersTree> templateCharacters, InternalSyntaxToken closeBacktickToken) {
        return new TemplateLiteralTreeImpl(openBacktickToken, templateCharacters.isPresent() ? Collections.singletonList(templateCharacters.get()) : Collections.emptyList(), closeBacktickToken);
    }

    public TemplateExpressionTreeImpl templateExpression(InternalSyntaxToken dollar, InternalSyntaxToken openCurlyBrace, ExpressionTree expression, InternalSyntaxToken closeCurlyBrace) {
        return new TemplateExpressionTreeImpl(dollar, openCurlyBrace, expression, closeCurlyBrace);
    }

    public TemplateLiteralTree substitutionTemplate(InternalSyntaxToken openBacktick, Optional<TemplateCharactersTree> firstCharacters, Optional<List<Tuple<TemplateExpressionTree, Optional<TemplateCharactersTree>>>> list, InternalSyntaxToken closeBacktick) {
        ArrayList<Tree> elements = new ArrayList<Tree>();
        if (firstCharacters.isPresent()) {
            elements.add((Tree)firstCharacters.get());
        }
        if (list.isPresent()) {
            for (Tuple tuple : (List)list.get()) {
                elements.add((Tree)tuple.first());
                if (!((Optional)tuple.second()).isPresent()) continue;
                elements.add((Tree)((Optional)tuple.second()).get());
            }
        }
        return new TemplateLiteralTreeImpl(openBacktick, elements, closeBacktick);
    }

    public TemplateCharactersTreeImpl templateCharacters(List<InternalSyntaxToken> characters) {
        ArrayList<InternalSyntaxToken> characterTokens = new ArrayList<InternalSyntaxToken>();
        for (InternalSyntaxToken character : characters) {
            characterTokens.add(character);
        }
        return new TemplateCharactersTreeImpl(characterTokens);
    }

    public IdentifierTree thisExpression(InternalSyntaxToken thisKeyword) {
        return new IdentifierTreeImpl(Tree.Kind.THIS, thisKeyword);
    }

    public IdentifierTreeImpl labelIdentifier(Tree spacing, InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.LABEL_IDENTIFIER, identifier);
    }

    public IdentifierTreeImpl labelIdentifier(InternalSyntaxToken identifier) {
        return new IdentifierTreeImpl(Tree.Kind.LABEL_IDENTIFIER, identifier);
    }

    public ExpressionTree assignmentExpression(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return TreeFactory.commonAssignmentExpression(variable, operator, expression);
    }

    public ExpressionTree assignmentWithArrayDestructuring(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return TreeFactory.commonAssignmentExpression(variable, operator, expression);
    }

    public ExpressionTree assignmentExpressionNoIn(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return TreeFactory.commonAssignmentExpression(variable, operator, expression);
    }

    private static ExpressionTree commonAssignmentExpression(ExpressionTree variable, InternalSyntaxToken operator, ExpressionTree expression) {
        return new AssignmentExpressionTreeImpl(EXPRESSION_KIND_BY_VALUE.get(operator.text()), variable, operator, expression);
    }

    public ExpressionTree expression(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree expressionNoIn(ExpressionTree expression, Optional<List<Tuple<InternalSyntaxToken, ExpressionTree>>> operatorAndOperands) {
        return TreeFactory.buildBinaryExpression(expression, operatorAndOperands);
    }

    public ExpressionTree expressionNoLineBreak(Tree spacingNoLineBreak, ExpressionTree expression) {
        return expression;
    }

    public FromClauseTreeImpl fromClause(InternalSyntaxToken fromToken, LiteralTreeImpl module) {
        return new FromClauseTreeImpl(fromToken, module);
    }

    public DefaultExportDeclarationTreeImpl defaultExportDeclaration(InternalSyntaxToken exportToken, InternalSyntaxToken defaultToken, Object declaration) {
        Tree deducedDeclaration;
        InternalSyntaxToken eos = null;
        if (declaration instanceof Tuple) {
            deducedDeclaration = (Tree)((Tuple)declaration).first();
            eos = TreeFactory.nullableSemicolonToken((Tree)((Tuple)declaration).second());
        } else {
            deducedDeclaration = (Tree)declaration;
        }
        return new DefaultExportDeclarationTreeImpl(exportToken, defaultToken, deducedDeclaration, eos);
    }

    public NamedExportDeclarationTreeImpl namedExportDeclaration(InternalSyntaxToken exportToken, Tree object) {
        return new NamedExportDeclarationTreeImpl(exportToken, object);
    }

    public SpecifierTreeImpl exportSpecifier(IdentifierTreeImpl name1, InternalSyntaxToken asToken, IdentifierTreeImpl name2) {
        return new SpecifierTreeImpl(Tree.Kind.EXPORT_SPECIFIER, name1, asToken, name2);
    }

    public SpecifierTreeImpl exportSpecifier(IdentifierTreeImpl name) {
        return new SpecifierTreeImpl(Tree.Kind.EXPORT_SPECIFIER, name);
    }

    public SpecifierTreeImpl completeExportSpecifier(IdentifierTreeImpl name, Optional<SpecifierTreeImpl> localName) {
        if (localName.isPresent()) {
            return ((SpecifierTreeImpl)localName.get()).complete(name);
        }
        return new SpecifierTreeImpl(Tree.Kind.EXPORT_SPECIFIER, name);
    }

    public SpecifierListTreeImpl newExportSpecifierList(SpecifierTreeImpl specifier, Optional<List<Tuple<InternalSyntaxToken, SpecifierTreeImpl>>> restSpecifier, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList specifiers = Lists.newArrayList();
        specifiers.add(specifier);
        if (restSpecifier.isPresent()) {
            for (Tuple t : (List)restSpecifier.get()) {
                commas.add(t.first());
                specifiers.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SpecifierListTreeImpl(Tree.Kind.EXPORT_LIST, new SeparatedList<SpecifierTree>(specifiers, commas));
    }

    public SpecifierListTreeImpl exportList(InternalSyntaxToken openCurlyBraceToken, Optional<SpecifierListTreeImpl> specifierList, InternalSyntaxToken closeCurlyBraceToken) {
        if (specifierList.isPresent()) {
            return ((SpecifierListTreeImpl)specifierList.get()).complete(openCurlyBraceToken, closeCurlyBraceToken);
        }
        return new SpecifierListTreeImpl(Tree.Kind.EXPORT_LIST, openCurlyBraceToken, closeCurlyBraceToken);
    }

    public NameSpaceExportDeclarationTree namespaceExportDeclaration(InternalSyntaxToken exportToken, InternalSyntaxToken starToken, Optional<Tuple<InternalSyntaxToken, IdentifierTreeImpl>> nameSpaceExport, FromClauseTreeImpl fromClause, Tree semicolonToken) {
        InternalSyntaxToken asToken = null;
        IdentifierTree synonymIdentifier = null;
        if (nameSpaceExport.isPresent()) {
            asToken = (InternalSyntaxToken)((Tuple)nameSpaceExport.get()).first;
            synonymIdentifier = (IdentifierTree)((Tuple)nameSpaceExport.get()).second;
        }
        return new NameSpaceExportDeclarationTreeImpl(exportToken, starToken, asToken, synonymIdentifier, fromClause, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportClauseTreeImpl exportClause(SpecifierListTreeImpl exportList, Optional<FromClauseTreeImpl> fromClause, Tree semicolonToken) {
        if (fromClause.isPresent()) {
            return new ExportClauseTreeImpl(exportList, (FromClauseTreeImpl)fromClause.get(), TreeFactory.nullableSemicolonToken(semicolonToken));
        }
        return new ExportClauseTreeImpl(exportList, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportDefaultBinding exportDefaultBinding(IdentifierTreeImpl identifierTree, FromClauseTreeImpl fromClauseTree, Tree semicolonToken) {
        return new ExportDefaultBindingImpl(identifierTree, fromClauseTree, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ExportDefaultBindingWithNameSpaceExport exportDefaultBindingWithNameSpaceExport(IdentifierTreeImpl identifierTree, InternalSyntaxToken commaToken, InternalSyntaxToken starToken, InternalSyntaxToken asToken, IdentifierTreeImpl synonymIdentifier, FromClauseTreeImpl fromClause, Tree semicolon) {
        return new ExportDefaultBindingWithNameSpaceExportImpl(identifierTree, commaToken, starToken, asToken, synonymIdentifier, fromClause, TreeFactory.nullableSemicolonToken(semicolon));
    }

    public ExportDefaultBindingWithExportList exportDefaultBindingWithExportList(IdentifierTreeImpl identifierTree, InternalSyntaxToken commaToken, SpecifierListTreeImpl specifierListTree, FromClauseTreeImpl fromClauseTree, Tree semicolon) {
        return new ExportDefaultBindingWithExportListImpl(identifierTree, commaToken, specifierListTree, fromClauseTree, TreeFactory.nullableSemicolonToken(semicolon));
    }

    public ImportModuleDeclarationTree importModuleDeclaration(InternalSyntaxToken importToken, LiteralTreeImpl moduleName, Tree semicolonToken) {
        return new ImportModuleDeclarationTreeImpl(importToken, moduleName, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public SpecifierTreeImpl newImportSpecifier(IdentifierTreeImpl name, InternalSyntaxToken asToken, IdentifierTreeImpl identifier) {
        return new SpecifierTreeImpl(Tree.Kind.IMPORT_SPECIFIER, name, asToken, identifier);
    }

    public SpecifierTreeImpl importSpecifier(IdentifierTreeImpl name) {
        return new SpecifierTreeImpl(Tree.Kind.IMPORT_SPECIFIER, name);
    }

    public SpecifierListTreeImpl newImportSpecifierList(SpecifierTreeImpl specifier, Optional<List<Tuple<InternalSyntaxToken, SpecifierTreeImpl>>> restSpecifier, Optional<InternalSyntaxToken> trailingComma) {
        ArrayList commas = Lists.newArrayList();
        ArrayList specifiers = Lists.newArrayList();
        specifiers.add(specifier);
        if (restSpecifier.isPresent()) {
            for (Tuple t : (List)restSpecifier.get()) {
                commas.add(t.first());
                specifiers.add(t.second());
            }
        }
        if (trailingComma.isPresent()) {
            commas.add(trailingComma.get());
        }
        return new SpecifierListTreeImpl(Tree.Kind.IMPORT_LIST, new SeparatedList<SpecifierTree>(specifiers, commas));
    }

    public SpecifierListTreeImpl importList(InternalSyntaxToken openCurlyBraceToken, Optional<SpecifierListTreeImpl> specifierList, InternalSyntaxToken closeCurlyBraceToken) {
        if (specifierList.isPresent()) {
            return ((SpecifierListTreeImpl)specifierList.get()).complete(openCurlyBraceToken, closeCurlyBraceToken);
        }
        return new SpecifierListTreeImpl(Tree.Kind.IMPORT_LIST, openCurlyBraceToken, closeCurlyBraceToken);
    }

    public NameSpaceSpecifierTreeImpl nameSpaceImport(InternalSyntaxToken starToken, InternalSyntaxToken asToken, IdentifierTreeImpl localName) {
        return new NameSpaceSpecifierTreeImpl(starToken, asToken, localName);
    }

    public ImportClauseTreeImpl defaultImport(IdentifierTreeImpl identifierTree, Optional<Tuple<InternalSyntaxToken, DeclarationTree>> namedImport) {
        if (namedImport.isPresent()) {
            return new ImportClauseTreeImpl(identifierTree, (InternalSyntaxToken)((Tuple)namedImport.get()).first(), (DeclarationTree)((Tuple)namedImport.get()).second());
        }
        return new ImportClauseTreeImpl(identifierTree);
    }

    public ImportClauseTreeImpl importClause(DeclarationTree importTree) {
        if (importTree instanceof ImportClauseTree) {
            return (ImportClauseTreeImpl)importTree;
        }
        return new ImportClauseTreeImpl(importTree);
    }

    public ImportDeclarationTreeImpl importDeclaration(InternalSyntaxToken importToken, ImportClauseTreeImpl importClause, FromClauseTreeImpl fromClause, Tree semicolonToken) {
        return new ImportDeclarationTreeImpl(importToken, importClause, fromClause, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public ModuleTreeImpl module(List<Tree> items) {
        return new ModuleTreeImpl(items);
    }

    public ClassTreeImpl classDeclaration(Optional<List<DecoratorTree>> decorators, InternalSyntaxToken classToken, IdentifierTreeImpl name, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> extendsClause, InternalSyntaxToken openCurlyBraceToken, Optional<List<Tree>> members, InternalSyntaxToken closeCurlyBraceToken) {
        ArrayList elements = Lists.newArrayList();
        if (members.isPresent()) {
            for (Tree member : (List)members.get()) {
                elements.add(member);
            }
        }
        if (extendsClause.isPresent()) {
            return ClassTreeImpl.newClassDeclaration(TreeFactory.optionalList(decorators), classToken, name, (InternalSyntaxToken)((Tuple)extendsClause.get()).first(), (ExpressionTree)((Tuple)extendsClause.get()).second(), openCurlyBraceToken, elements, closeCurlyBraceToken);
        }
        return ClassTreeImpl.newClassDeclaration(TreeFactory.optionalList(decorators), classToken, name, null, null, openCurlyBraceToken, elements, closeCurlyBraceToken);
    }

    public GeneratorMethodDeclarationTree generator(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, InternalSyntaxToken starToken, Tree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return new GeneratorMethodDeclarationTreeImpl(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), starToken, name, parameters, body);
    }

    public MethodDeclarationTreeImpl method(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, Optional<InternalSyntaxToken> asyncToken, Tree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return new MethodDeclarationTreeImpl(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), (InternalSyntaxToken)asyncToken.orNull(), name, parameters, body);
    }

    public AccessorMethodDeclarationTree accessor(Optional<List<DecoratorTree>> decorators, Optional<InternalSyntaxToken> staticToken, InternalSyntaxToken accessorToken, Tree name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return new AccessorMethodDeclarationTreeImpl(TreeFactory.optionalList(decorators), (InternalSyntaxToken)staticToken.orNull(), accessorToken, name, parameters, body);
    }

    public FunctionDeclarationTree functionAndGeneratorDeclaration(Optional<InternalSyntaxToken> asyncToken, InternalSyntaxToken functionToken, Optional<InternalSyntaxToken> starToken, IdentifierTreeImpl name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        return starToken.isPresent() ? FunctionDeclarationTreeImpl.createGenerator(functionToken, (InternalSyntaxToken)starToken.get(), name, parameters, body) : FunctionDeclarationTreeImpl.create((SyntaxToken)asyncToken.orNull(), functionToken, name, parameters, body);
    }

    public InitializedBindingElementTreeImpl newInitializedBindingElement1(InternalSyntaxToken equalToken, ExpressionTree expression) {
        return new InitializedBindingElementTreeImpl(equalToken, expression);
    }

    public InitializedBindingElementTreeImpl newInitializedBindingElement2(InternalSyntaxToken equalToken, ExpressionTree expression) {
        return new InitializedBindingElementTreeImpl(equalToken, expression);
    }

    private static BindingElementTree completeBindingElement(BindingElementTree left, Optional<InitializedBindingElementTreeImpl> initializer) {
        if (!initializer.isPresent()) {
            return left;
        }
        return ((InitializedBindingElementTreeImpl)initializer.get()).completeWithLeft(left);
    }

    public BindingElementTree completeBindingElement1(BindingElementTree left, Optional<InitializedBindingElementTreeImpl> initializer) {
        return TreeFactory.completeBindingElement(left, initializer);
    }

    public BindingElementTree completeBindingElement2(BindingElementTree left, Optional<InitializedBindingElementTreeImpl> initializer) {
        return TreeFactory.completeBindingElement(left, initializer);
    }

    public BindingPropertyTreeImpl bindingProperty(Tree propertyName, InternalSyntaxToken colonToken, BindingElementTree bindingElement) {
        return new BindingPropertyTreeImpl(propertyName, colonToken, bindingElement);
    }

    public RestElementTreeImpl restObjectBindingElement(InternalSyntaxToken ellipsis, BindingElementTree bindingElement) {
        return new RestElementTreeImpl(ellipsis, bindingElement);
    }

    public SeparatedList<BindingElementTree> bindingPropertyList(BindingElementTree bindingProperty, Optional<List<Tuple<InternalSyntaxToken, BindingElementTree>>> restProperties) {
        ArrayList properties = Lists.newArrayList();
        ArrayList commas = Lists.newArrayList();
        properties.add(bindingProperty);
        if (restProperties.isPresent()) {
            for (Tuple tuple : (List)restProperties.get()) {
                commas.add(tuple.first());
                properties.add(tuple.second());
            }
        }
        return new SeparatedList<BindingElementTree>(properties, commas);
    }

    public ObjectBindingPatternTreeImpl objectBindingPattern(InternalSyntaxToken lCurlyBrace, Optional<SeparatedList<BindingElementTree>> list, Optional<Tuple<InternalSyntaxToken, Optional<RestElementTree>>> commaAndRest, InternalSyntaxToken rCurlyBrace) {
        SeparatedList<BindingElementTree> elements = list.isPresent() ? (SeparatedList<BindingElementTree>)list.get() : new SeparatedList<BindingElementTree>(new ArrayList(), new ArrayList<InternalSyntaxToken>());
        if (commaAndRest.isPresent()) {
            elements.getSeparators().add((InternalSyntaxToken)((Tuple)commaAndRest.get()).first);
            if (((Optional)((Tuple)commaAndRest.get()).second).isPresent()) {
                elements.add((BindingElementTree)((Optional)((Tuple)commaAndRest.get()).second).get());
            }
        }
        return new ObjectBindingPatternTreeImpl(lCurlyBrace, elements, rCurlyBrace);
    }

    public ObjectBindingPatternTreeImpl objectBindingPattern2(InternalSyntaxToken lCurlyBrace, RestElementTree rest, InternalSyntaxToken rCurlyBrace) {
        return new ObjectBindingPatternTreeImpl(lCurlyBrace, new SeparatedList<BindingElementTree>((List<BindingElementTree>)ImmutableList.of((Object)rest), (List<InternalSyntaxToken>)ImmutableList.of()), rCurlyBrace);
    }

    public ArrayBindingPatternTreeImpl arrayBindingPattern(InternalSyntaxToken openBracketToken, Optional<BindingElementTree> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<BindingElementTree>>>> optionalElements, Optional<BindingElementTree> restElement, InternalSyntaxToken closeBracketToken) {
        return new ArrayBindingPatternTreeImpl(openBracketToken, TreeFactory.getSeparatedListOfOptional(firstElement, optionalElements, restElement), closeBracketToken);
    }

    public ArrayAssignmentPatternTree arrayAssignmentPattern(InternalSyntaxToken openBracketToken, Optional<Tree> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<Tree>>>> optionalElements, Optional<Tree> restElement, InternalSyntaxToken closeBracketToken) {
        return new ArrayAssignmentPatternTreeImpl(openBracketToken, TreeFactory.getSeparatedListOfOptional(firstElement, optionalElements, restElement), closeBracketToken);
    }

    private static <T extends Tree> SeparatedList<Optional<T>> getSeparatedListOfOptional(Optional<T> firstElement, Optional<List<Tuple<InternalSyntaxToken, Optional<T>>>> optionalElements, Optional<T> restElement) {
        ImmutableList.Builder elements = ImmutableList.builder();
        ImmutableList.Builder separators = ImmutableList.builder();
        boolean skipComma = false;
        if (firstElement.isPresent()) {
            elements.add(firstElement);
            skipComma = true;
        }
        if (optionalElements.isPresent()) {
            List list = (List)optionalElements.get();
            for (Tuple pair : list) {
                if (!skipComma) {
                    elements.add((Object)Optional.absent());
                }
                InternalSyntaxToken commaToken = (InternalSyntaxToken)pair.first();
                separators.add((Object)commaToken);
                if (((Optional)pair.second()).isPresent()) {
                    elements.add(pair.second());
                    skipComma = true;
                    continue;
                }
                skipComma = false;
            }
        }
        if (restElement.isPresent()) {
            elements.add((Object)Optional.of((Object)restElement.get()));
        }
        return new SeparatedList<Optional<T>>(elements.build(), (List<InternalSyntaxToken>)separators.build());
    }

    public ExpressionTree assignmentNoCurly(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree assignmentNoCurlyNoIn(Tree lookahead, ExpressionTree expressionNoIn) {
        return expressionNoIn;
    }

    public ExpressionTree skipLookahead1(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree skipLookahead2(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree skipLookahead3(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public ExpressionTree skipLookahead4(ExpressionTree expression, Tree lookahead) {
        return expression;
    }

    public ScriptTreeImpl script(Optional<InternalSyntaxToken> shebangToken, Optional<ModuleTreeImpl> items, Tree spacing, InternalSyntaxToken eof) {
        return new ScriptTreeImpl(shebangToken.isPresent() ? (InternalSyntaxToken)shebangToken.get() : null, items.isPresent() ? (ModuleTreeImpl)items.get() : null, eof);
    }

    public ExpressionTree defaultExportExpression(Tree lookahead, ExpressionTree expression) {
        return expression;
    }

    public JsxSelfClosingElementTree jsxSelfClosingElement(InternalSyntaxToken ltToken, JsxElementNameTree jsxElementNameTree, Optional<List<JsxAttributeTree>> attributes, InternalSyntaxToken divToken, InternalSyntaxToken gtToken) {
        return new JsxSelfClosingElementTreeImpl(ltToken, jsxElementNameTree, TreeFactory.optionalList(attributes), divToken, gtToken);
    }

    public JsxStandardElementTree jsxStandardElement(JsxOpeningElementTree jsxOpeningElementTree, Optional<List<JsxChildTree>> children, JsxClosingElementTree jsxClosingElementTree) {
        return new JsxStandardElementTreeImpl(jsxOpeningElementTree, TreeFactory.optionalList(children), jsxClosingElementTree);
    }

    public JsxOpeningElementTree jsxOpeningElement(InternalSyntaxToken ltToken, JsxElementNameTree jsxElementNameTree, Optional<List<JsxAttributeTree>> attributes, InternalSyntaxToken gtToken) {
        return new JsxOpeningElementTreeImpl(ltToken, jsxElementNameTree, TreeFactory.optionalList(attributes), gtToken);
    }

    public JsxClosingElementTree jsxClosingElement(InternalSyntaxToken ltToken, InternalSyntaxToken divToken, JsxElementNameTree jsxElementNameTree, InternalSyntaxToken gtToken) {
        return new JsxClosingElementTreeImpl(ltToken, divToken, jsxElementNameTree, gtToken);
    }

    public JsxJavaScriptExpressionTree jsxJavaScriptExpression(InternalSyntaxToken lCurlyBraceToken, Optional<ExpressionTree> expression, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxJavaScriptExpressionTreeImpl(lCurlyBraceToken, (ExpressionTree)expression.orNull(), rCurlyBraceToken);
    }

    public JsxJavaScriptExpressionTree jsxJavaScriptExpression(InternalSyntaxToken lCurlyBraceToken, ExpressionTree expression, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxJavaScriptExpressionTreeImpl(lCurlyBraceToken, expression, rCurlyBraceToken);
    }

    public JsxStandardAttributeTree jsxStandardAttribute(JsxIdentifierTree name, InternalSyntaxToken equalToken, JsxAttributeValueTree jsxAttributeValueTree) {
        return new JsxStandardAttributeTreeImpl(name, equalToken, jsxAttributeValueTree);
    }

    public JsxSpreadAttributeTree jsxSpreadAttribute(InternalSyntaxToken lCurlyBraceToken, InternalSyntaxToken ellipsisToken, ExpressionTree expressionTree, InternalSyntaxToken rCurlyBraceToken) {
        return new JsxSpreadAttributeTreeImpl(lCurlyBraceToken, ellipsisToken, expressionTree, rCurlyBraceToken);
    }

    public JsxTextTree jsxTextTree(InternalSyntaxToken token) {
        return new JsxTextTreeImpl(token);
    }

    public JsxIdentifierTree jsxIdentifier(InternalSyntaxToken identifierToken) {
        return new JsxIdentifierTreeImpl(identifierToken);
    }

    public JsxIdentifierTree jsxHtmlTag(InternalSyntaxToken htmlTagToken) {
        return new JsxIdentifierTreeImpl(htmlTagToken);
    }

    public ExpressionTree jsxMemberExpression(IdentifierTree identifierTree, List<Tuple<InternalSyntaxToken, IdentifierTreeImpl>> rest) {
        ExpressionTree currentObject = identifierTree;
        for (Tuple<InternalSyntaxToken, IdentifierTreeImpl> tuple : rest) {
            DotMemberExpressionTreeImpl newMemberExpression = new DotMemberExpressionTreeImpl((InternalSyntaxToken)((Tuple)tuple).first, (IdentifierTree)((Tuple)tuple).second);
            newMemberExpression.complete(currentObject);
            currentObject = newMemberExpression;
        }
        return currentObject;
    }

    public FieldDeclarationTree fieldDeclaration(Optional<InternalSyntaxToken> staticToken, Tree propertyName, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> initializer, Tree semicolonToken) {
        if (initializer.isPresent()) {
            return new FieldDeclarationTreeImpl((SyntaxToken)staticToken.orNull(), propertyName, (SyntaxToken)((Tuple)initializer.get()).first, (ExpressionTree)((Tuple)initializer.get()).second, TreeFactory.nullableSemicolonToken(semicolonToken));
        }
        return new FieldDeclarationTreeImpl((SyntaxToken)staticToken.orNull(), propertyName, null, null, TreeFactory.nullableSemicolonToken(semicolonToken));
    }

    public DecoratorTree decorator(InternalSyntaxToken atToken, IdentifierTreeImpl name, Optional<List<Tuple<InternalSyntaxToken, IdentifierTree>>> rest, Optional<ParameterListTree> arguments) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableList.Builder dotsListBuilder = ImmutableList.builder();
        listBuilder.add((Object)name);
        for (Tuple tuple : (List)rest.or(new ArrayList())) {
            dotsListBuilder.add(tuple.first);
            listBuilder.add(tuple.second);
        }
        SeparatedList<IdentifierTree> body = new SeparatedList<IdentifierTree>((List<IdentifierTree>)listBuilder.build(), (List<InternalSyntaxToken>)dotsListBuilder.build());
        return new DecoratorTreeImpl(atToken, body, (ParameterListTree)arguments.orNull());
    }

    public AssignmentPatternRestElementTreeImpl assignmentPatternRestElement(InternalSyntaxToken ellipsisToken, ExpressionTree rest) {
        return new AssignmentPatternRestElementTreeImpl(ellipsisToken, rest);
    }

    public InitializedAssignmentPatternElementTree initializedAssignmentPatternElement1(ExpressionTree expression, InternalSyntaxToken equal, ExpressionTree initValue) {
        return new InitializedAssignmentPatternElementTreeImpl(expression, equal, initValue);
    }

    public InitializedAssignmentPatternElementTree initializedAssignmentPatternElement2(ExpressionTree expression, InternalSyntaxToken equal, ExpressionTree initValue) {
        return new InitializedAssignmentPatternElementTreeImpl(expression, equal, initValue);
    }

    public ObjectAssignmentPatternPairElementTree objectAssignmentPatternPairElement(IdentifierTree identifierName, InternalSyntaxToken colonToken, Tree rhs) {
        return new ObjectAssignmentPatternPairElementTreeImpl(identifierName, colonToken, rhs);
    }

    public ObjectAssignmentPatternTree emptyObjectAssignmentPattern(InternalSyntaxToken lBrace, InternalSyntaxToken rBrace) {
        return new ObjectAssignmentPatternTreeImpl(lBrace, new SeparatedList<Tree>(new ArrayList(), new ArrayList<InternalSyntaxToken>()), rBrace);
    }

    public ObjectAssignmentPatternTree objectAssignmentPattern(InternalSyntaxToken lBrace, Tree firstProperty, Optional<List<Tuple<InternalSyntaxToken, Tree>>> properties, Optional<InternalSyntaxToken> comma, InternalSyntaxToken rBrace) {
        ArrayList<Object> propertyList = new ArrayList<Object>();
        ArrayList<InternalSyntaxToken> separators = new ArrayList<InternalSyntaxToken>();
        propertyList.add(firstProperty);
        for (Tuple tuple : (List)properties.or(new ArrayList())) {
            separators.add((InternalSyntaxToken)tuple.first);
            propertyList.add(tuple.second);
        }
        if (comma.isPresent()) {
            separators.add((InternalSyntaxToken)comma.get());
        }
        return new ObjectAssignmentPatternTreeImpl(lBrace, new SeparatedList<Tree>(propertyList, separators), rBrace);
    }

    private static <T> List<T> optionalList(Optional<List<T>> list) {
        if (list.isPresent()) {
            return (List)list.get();
        }
        return Collections.emptyList();
    }

    private static <T, U> Tuple<T, U> newTuple(T first, U second) {
        return new Tuple<T, U>(first, second);
    }

    public <T, U> Tuple<T, U> newTuple1(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple2(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple3(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple4(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple5(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple6(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple7(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple8(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple9(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple10(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple11(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple12(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple13(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple14(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple15(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple16(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple17(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple18(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple19(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple20(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple21(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple22(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple23(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple24(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple25(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple26(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple27(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple28(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple29(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple30(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple31(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple32(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple48(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple49(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple50(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple51(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple52(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple53(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple54(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple55(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple56(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple57(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple58(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple59(T first, U second) {
        return TreeFactory.newTuple(first, second);
    }

    static {
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OROR.getValue(), Tree.Kind.CONDITIONAL_OR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.ANDAND.getValue(), Tree.Kind.CONDITIONAL_AND);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OR.getValue(), Tree.Kind.BITWISE_OR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.XOR.getValue(), Tree.Kind.BITWISE_XOR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.AND.getValue(), Tree.Kind.BITWISE_AND);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQUAL.getValue(), Tree.Kind.EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.NOTEQUAL.getValue(), Tree.Kind.NOT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQUAL2.getValue(), Tree.Kind.STRICT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.NOTEQUAL2.getValue(), Tree.Kind.STRICT_NOT_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.LT.getValue(), Tree.Kind.LESS_THAN);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.GT.getValue(), Tree.Kind.GREATER_THAN);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.LE.getValue(), Tree.Kind.LESS_THAN_OR_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.GE.getValue(), Tree.Kind.GREATER_THAN_OR_EQUAL_TO);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SL.getValue(), Tree.Kind.LEFT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR.getValue(), Tree.Kind.RIGHT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR2.getValue(), Tree.Kind.UNSIGNED_RIGHT_SHIFT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.PLUS.getValue(), Tree.Kind.PLUS);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MINUS.getValue(), Tree.Kind.MINUS);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.STAR.getValue(), Tree.Kind.MULTIPLY);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EXP.getValue(), Tree.Kind.EXPONENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.DIV.getValue(), Tree.Kind.DIVIDE);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MOD.getValue(), Tree.Kind.REMAINDER);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EQU.getValue(), Tree.Kind.ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.STAR_EQU.getValue(), Tree.Kind.MULTIPLY_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.EXP_EQU.getValue(), Tree.Kind.EXPONENT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.DIV_EQU.getValue(), Tree.Kind.DIVIDE_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MOD_EQU.getValue(), Tree.Kind.REMAINDER_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.PLUS_EQU.getValue(), Tree.Kind.PLUS_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.MINUS_EQU.getValue(), Tree.Kind.MINUS_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SL_EQU.getValue(), Tree.Kind.LEFT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR_EQU.getValue(), Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.SR_EQU2.getValue(), Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.AND_EQU.getValue(), Tree.Kind.AND_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.XOR_EQU.getValue(), Tree.Kind.XOR_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.OR_EQU.getValue(), Tree.Kind.OR_ASSIGNMENT);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptPunctuator.COMMA.getValue(), Tree.Kind.COMMA_OPERATOR);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptKeyword.INSTANCEOF.getValue(), Tree.Kind.INSTANCE_OF);
        EXPRESSION_KIND_BY_VALUE.put(JavaScriptKeyword.IN.getValue(), Tree.Kind.RELATIONAL_IN);
        PREFIX_KIND_BY_VALUE = ImmutableMap.builder().put((Object)JavaScriptPunctuator.INC.getValue(), (Object)Tree.Kind.PREFIX_INCREMENT).put((Object)JavaScriptPunctuator.DEC.getValue(), (Object)Tree.Kind.PREFIX_DECREMENT).put((Object)JavaScriptPunctuator.PLUS.getValue(), (Object)Tree.Kind.UNARY_PLUS).put((Object)JavaScriptPunctuator.MINUS.getValue(), (Object)Tree.Kind.UNARY_MINUS).put((Object)JavaScriptPunctuator.TILDA.getValue(), (Object)Tree.Kind.BITWISE_COMPLEMENT).put((Object)JavaScriptPunctuator.BANG.getValue(), (Object)Tree.Kind.LOGICAL_COMPLEMENT).put((Object)JavaScriptKeyword.DELETE.getValue(), (Object)Tree.Kind.DELETE).put((Object)JavaScriptKeyword.VOID.getValue(), (Object)Tree.Kind.VOID).put((Object)JavaScriptKeyword.TYPEOF.getValue(), (Object)Tree.Kind.TYPEOF).put((Object)JavaScriptKeyword.AWAIT.getValue(), (Object)Tree.Kind.AWAIT).build();
    }

    public static class Tuple<T, U> {
        private final T first;
        private final U second;

        public Tuple(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T first() {
            return this.first;
        }

        public U second() {
            return this.second;
        }
    }
}

