/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.sv.FunctionSymbolicValue;
import org.sonar.javascript.se.sv.LiteralSymbolicValue;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.PlusSymbolicValue;
import org.sonar.javascript.se.sv.RelationalSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.se.sv.TypeOfSymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;

public class ExpressionStack {
    private static final ExpressionStack EMPTY = new ExpressionStack();
    private final Deque<SymbolicValue> stack;

    private ExpressionStack() {
        this.stack = new LinkedList<SymbolicValue>();
    }

    private ExpressionStack(Deque<SymbolicValue> stack) {
        this.stack = stack;
    }

    public static ExpressionStack emptyStack() {
        return EMPTY;
    }

    public ExpressionStack push(@Nullable SymbolicValue newValue) {
        SymbolicValue pushedValue = newValue;
        if (pushedValue == null) {
            pushedValue = UnknownSymbolicValue.UNKNOWN;
        }
        Deque<SymbolicValue> newStack = this.copy();
        newStack.push(pushedValue);
        return new ExpressionStack(newStack);
    }

    public ExpressionStack execute(ExpressionTree expression) {
        Deque<SymbolicValue> newStack = this.copy();
        Tree.Kind kind = ((JavaScriptTree)((Object)expression)).getKind();
        switch (kind) {
            case IDENTIFIER_REFERENCE: {
                if (SymbolicExecution.isUndefined((IdentifierTree)expression)) {
                    newStack.push(SpecialSymbolicValue.UNDEFINED);
                    break;
                }
                throw new IllegalArgumentException("Unexpected kind of expression to execute: " + (Object)((Object)kind));
            }
            case IDENTIFIER_NAME: 
            case BINDING_IDENTIFIER: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case CONDITIONAL_EXPRESSION: {
                break;
            }
            case NULL_LITERAL: {
                newStack.push(SpecialSymbolicValue.NULL);
                break;
            }
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: {
                newStack.push(LiteralSymbolicValue.get((LiteralTree)expression));
                break;
            }
            case LOGICAL_COMPLEMENT: {
                SymbolicValue negatedValue = newStack.pop();
                newStack.push(LogicalNotSymbolicValue.create(negatedValue));
                break;
            }
            case TYPEOF: {
                newStack.push(new TypeOfSymbolicValue(newStack.pop()));
                break;
            }
            case NEW_EXPRESSION: {
                NewExpressionTree newExpressionTree = (NewExpressionTree)expression;
                int arguments = newExpressionTree.arguments() == null ? 0 : newExpressionTree.arguments().parameters().size();
                ExpressionStack.pop(newStack, arguments + 1);
                newStack.push(new SymbolicValueWithConstraint(Constraint.OBJECT));
                break;
            }
            case DOT_MEMBER_EXPRESSION: 
            case SPREAD_ELEMENT: 
            case VOID: 
            case AWAIT: {
                ExpressionStack.pop(newStack, 1);
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case DELETE: {
                ExpressionStack.pop(newStack, 1);
                newStack.push(new SymbolicValueWithConstraint(Constraint.BOOLEAN));
                break;
            }
            case YIELD_EXPRESSION: {
                if (((YieldExpressionTree)expression).argument() != null) {
                    ExpressionStack.pop(newStack, 1);
                }
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: 
            case BITWISE_COMPLEMENT: {
                ExpressionStack.pop(newStack, 1);
                newStack.push(new SymbolicValueWithConstraint(Constraint.NUMBER));
                break;
            }
            case CALL_EXPRESSION: {
                ExpressionStack.pop(newStack, ((CallExpressionTree)expression).arguments().parameters().size() + 1);
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case FUNCTION_EXPRESSION: 
            case GENERATOR_FUNCTION_EXPRESSION: 
            case ARROW_FUNCTION: {
                newStack.push(new FunctionSymbolicValue((FunctionTree)((Object)expression)));
                break;
            }
            case REGULAR_EXPRESSION_LITERAL: 
            case THIS: 
            case SUPER: 
            case NEW_TARGET: 
            case JSX_SELF_CLOSING_ELEMENT: 
            case JSX_STANDARD_ELEMENT: {
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case CLASS_EXPRESSION: {
                newStack.push(new SymbolicValueWithConstraint(Constraint.OTHER_OBJECT));
                break;
            }
            case OBJECT_LITERAL: {
                ExpressionStack.popObjectLiteralProperties((ObjectLiteralTree)expression, newStack);
                newStack.push(new SymbolicValueWithConstraint(Constraint.OTHER_OBJECT));
                break;
            }
            case ARRAY_LITERAL: {
                ExpressionStack.pop(newStack, ((ArrayLiteralTree)expression).elements().size());
                newStack.push(new SymbolicValueWithConstraint(Constraint.ARRAY));
                break;
            }
            case TEMPLATE_LITERAL: {
                ExpressionStack.pop(newStack, ((TemplateLiteralTree)expression).expressions().size());
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case EXPONENT_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case BRACKET_MEMBER_EXPRESSION: 
            case TAGGED_TEMPLATE: 
            case EXPONENT: 
            case RELATIONAL_IN: 
            case INSTANCE_OF: {
                ExpressionStack.pop(newStack, 2);
                ExpressionStack.pushUnknown(newStack);
                break;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case STRICT_EQUAL_TO: 
            case STRICT_NOT_EQUAL_TO: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL_TO: 
            case GREATER_THAN_OR_EQUAL_TO: {
                SymbolicValue rightOperand = newStack.pop();
                SymbolicValue leftOperand = newStack.pop();
                newStack.push(RelationalSymbolicValue.create(kind, leftOperand, rightOperand));
                break;
            }
            case PLUS: {
                newStack.push(new PlusSymbolicValue(newStack.pop(), newStack.pop()));
                break;
            }
            case MINUS: 
            case DIVIDE: 
            case REMAINDER: 
            case MULTIPLY: 
            case BITWISE_AND: 
            case BITWISE_XOR: 
            case BITWISE_OR: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                ExpressionStack.pop(newStack, 2);
                newStack.push(new SymbolicValueWithConstraint(Constraint.NUMBER));
                break;
            }
            case COMMA_OPERATOR: {
                SymbolicValue commaResult = newStack.pop();
                newStack.pop();
                newStack.push(commaResult);
                break;
            }
            case ASSIGNMENT: {
                SymbolicValue assignedValue = newStack.pop();
                newStack.pop();
                newStack.push(assignedValue);
                break;
            }
            case ARRAY_ASSIGNMENT_PATTERN: 
            case OBJECT_ASSIGNMENT_PATTERN: {
                newStack.push(UnknownSymbolicValue.UNKNOWN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected kind of expression to execute: " + (Object)((Object)kind));
            }
        }
        return new ExpressionStack(newStack);
    }

    private static void popObjectLiteralProperties(ObjectLiteralTree objectLiteralTree, Deque<SymbolicValue> newStack) {
        for (Tree property : objectLiteralTree.properties()) {
            if (property.is(Tree.Kind.PAIR_PROPERTY)) {
                Tree key = ((PairPropertyTree)property).key();
                if (key.is(Tree.Kind.STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.COMPUTED_PROPERTY_NAME)) {
                    newStack.pop();
                }
            }
            if (property instanceof MethodDeclarationTree) continue;
            newStack.pop();
        }
    }

    private Deque<SymbolicValue> copy() {
        return new LinkedList<SymbolicValue>(this.stack);
    }

    public SymbolicValue peek() {
        return this.stack.peek();
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExpressionStack) {
            ExpressionStack other = (ExpressionStack)obj;
            return Objects.equals(this.stack, other.stack);
        }
        return false;
    }

    private static void pop(Deque<SymbolicValue> newStack, int n) {
        for (int i = 0; i < n; ++i) {
            newStack.pop();
        }
    }

    public SymbolicValue peek(int n) {
        Preconditions.checkArgument((n < this.stack.size() ? 1 : 0) != 0);
        Iterator<SymbolicValue> iterator = this.stack.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    private static void pushUnknown(Deque<SymbolicValue> newStack) {
        newStack.push(UnknownSymbolicValue.UNKNOWN);
    }

    public ExpressionStack removeLastValue() {
        Deque<SymbolicValue> newStack = this.copy();
        newStack.pop();
        return new ExpressionStack(newStack);
    }

    public String toString() {
        return this.stack.toString();
    }
}

