/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class LiveVariableAnalysis {
    private final Usages usages;
    private Map<CfgBlock, BlockLiveness> livenessPerBlock;

    public Set<Symbol> getLiveOutSymbols(CfgBlock block) {
        BlockLiveness blockLiveness = this.livenessPerBlock.get(block);
        return blockLiveness.liveOut;
    }

    public Set<Symbol> getLiveInSymbols(CfgBlock block) {
        BlockLiveness blockLiveness = this.livenessPerBlock.get(block);
        return blockLiveness.liveIn;
    }

    private LiveVariableAnalysis(ControlFlowGraph cfg, Scope scope) {
        this.usages = new Usages(scope);
        HashSet<BlockLiveness> livenesses = new HashSet<BlockLiveness>();
        this.buildUsagesAndLivenesses(cfg, this.usages, livenesses);
    }

    public static LiveVariableAnalysis create(ControlFlowGraph cfg, Scope scope) {
        return new LiveVariableAnalysis(cfg, scope);
    }

    private void buildUsagesAndLivenesses(ControlFlowGraph cfg, Usages usages, Set<BlockLiveness> livenesses) {
        BlockLiveness blockLiveness;
        this.livenessPerBlock = new HashMap<CfgBlock, BlockLiveness>();
        for (CfgBlock block : cfg.blocks()) {
            blockLiveness = new BlockLiveness(block, usages);
            this.livenessPerBlock.put(block, blockLiveness);
            livenesses.add(blockLiveness);
        }
        ArrayDeque<CfgBlock> queue = new ArrayDeque<CfgBlock>(cfg.blocks());
        while (!queue.isEmpty()) {
            CfgBlock block;
            block = (CfgBlock)queue.pop();
            blockLiveness = this.livenessPerBlock.get(block);
            boolean changed = blockLiveness.updateLiveInAndOut(this.livenessPerBlock);
            if (!changed) continue;
            block.predecessors().forEach(queue::push);
        }
    }

    public Usages getUsages() {
        return this.usages;
    }

    public static boolean isRead(@Nullable Usage usage) {
        if (usage == null) {
            return false;
        }
        return usage.kind() == Usage.Kind.READ || usage.kind() == Usage.Kind.READ_WRITE;
    }

    public static boolean isWrite(@Nullable Usage usage) {
        if (usage == null) {
            return false;
        }
        return usage.kind() == Usage.Kind.WRITE || usage.kind() == Usage.Kind.DECLARATION_WRITE;
    }

    public static class Usages {
        private final Scope functionScope;
        private final Set<Symbol> symbols = new HashSet<Symbol>();
        private final Map<IdentifierTree, Usage> localVariableUsages = new HashMap<IdentifierTree, Usage>();
        private final Set<Symbol> neverReadSymbols = new HashSet<Symbol>();
        private final SetMultimap<Symbol, Usage> usagesInCFG = HashMultimap.create();
        private final Set<Tree> assignmentVariables = new HashSet<Tree>();

        private Usages(Scope functionScope) {
            this.functionScope = functionScope;
        }

        public Usage getUsage(Tree element) {
            if (this.assignmentVariables.contains(element)) {
                return null;
            }
            if (element.is(Tree.Kind.ASSIGNMENT)) {
                return this.localVariableUsages.get(((AssignmentExpressionTree)element).variable());
            }
            return this.localVariableUsages.get(element);
        }

        public boolean hasUsagesInNestedFunctions(Symbol symbol) {
            return this.usagesInCFG.get((Object)symbol).size() != symbol.usages().size();
        }

        @CheckForNull
        private Usage add(IdentifierTree identifier) {
            this.addSymbol(identifier.symbol());
            Usage usage = this.localVariableUsages.get(identifier);
            if (usage != null) {
                this.usagesInCFG.put((Object)identifier.symbol(), (Object)usage);
            }
            return usage;
        }

        private void addSymbol(@Nullable Symbol symbol) {
            if (symbol == null || this.symbols.contains(symbol)) {
                return;
            }
            this.symbols.add(symbol);
            if (this.isLocalVariable(symbol)) {
                boolean readAtLeastOnce = false;
                for (Usage usage : symbol.usages()) {
                    this.localVariableUsages.put(usage.identifierTree(), usage);
                    if (!LiveVariableAnalysis.isRead(usage)) continue;
                    readAtLeastOnce = true;
                }
                if (!readAtLeastOnce) {
                    this.neverReadSymbols.add(symbol);
                }
            }
        }

        private boolean isLocalVariable(Symbol symbol) {
            Scope scope = symbol.scope();
            while (!scope.isGlobal()) {
                if (scope.equals(this.functionScope)) {
                    return true;
                }
                scope = scope.outer();
            }
            return false;
        }

        public Set<Symbol> neverReadSymbols() {
            return this.neverReadSymbols;
        }

        private void addAssignment(AssignmentExpressionTree tree) {
            this.assignmentVariables.add(tree.variable());
        }
    }

    private static class BlockLiveness {
        private final CfgBlock block;
        private final Usages usages;
        private final Set<Symbol> liveOut = new HashSet<Symbol>();
        private Set<Symbol> liveIn = new HashSet<Symbol>();

        private BlockLiveness(CfgBlock block, Usages usages) {
            this.usages = usages;
            this.block = block;
            for (Tree element : block.elements()) {
                if (element instanceof IdentifierTree) {
                    usages.add((IdentifierTree)element);
                }
                if (!element.is(Tree.Kind.ASSIGNMENT)) continue;
                usages.addAssignment((AssignmentExpressionTree)element);
            }
        }

        private boolean updateLiveInAndOut(Map<CfgBlock, BlockLiveness> livenessPerBlock) {
            this.liveOut.clear();
            for (CfgBlock successor : this.block.successors()) {
                this.liveOut.addAll(livenessPerBlock.get((Object)successor).liveIn);
            }
            Set<Symbol> oldIn = this.liveIn;
            this.liveIn = new HashSet<Symbol>(this.liveOut);
            for (Tree element : Lists.reverse(this.block.elements())) {
                Usage usage = this.usages.getUsage(element);
                if (LiveVariableAnalysis.isWrite(usage)) {
                    this.liveIn.remove(usage.symbol());
                    continue;
                }
                if (!LiveVariableAnalysis.isRead(usage)) continue;
                this.liveIn.add(usage.symbol());
            }
            return !oldIn.equals(this.liveIn);
        }
    }
}

