/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.sv.SymbolicValue;

public class PlusSymbolicValue
implements SymbolicValue {
    private final SymbolicValue firstOperandValue;
    private final SymbolicValue secondOperandValue;

    public PlusSymbolicValue(SymbolicValue firstOperandValue, SymbolicValue secondOperandValue) {
        Preconditions.checkArgument((firstOperandValue != null ? 1 : 0) != 0, (Object)"operand value should not be null");
        Preconditions.checkArgument((secondOperandValue != null ? 1 : 0) != 0, (Object)"operand value should not be null");
        this.firstOperandValue = firstOperandValue;
        this.secondOperandValue = secondOperandValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        EnumSet<Type> numberTypes = EnumSet.of(Type.NUMBER, Type.BOOLEAN);
        Type firstType = state.getConstraint(this.firstOperandValue).type();
        Type secondType = state.getConstraint(this.secondOperandValue).type();
        if (firstType != null || secondType != null) {
            if (firstType == Type.STRING || secondType == Type.STRING) {
                return Constraint.STRING;
            }
            if (numberTypes.contains((Object)firstType) && numberTypes.contains((Object)secondType)) {
                return Constraint.NUMBER;
            }
        }
        return Constraint.NUMBER.or(Constraint.STRING);
    }

    public String toString() {
        return this.firstOperandValue + " + " + this.secondOperandValue;
    }
}

