/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Relation;
import org.sonar.javascript.se.sv.EqualitySymbolicValue;
import org.sonar.javascript.se.sv.LogicalNotSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.TypeOfComparisonSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;

public class RelationalSymbolicValue
implements SymbolicValue {
    private static final Set<Tree.Kind> EQUALITY_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO);
    private final Relation relationWhenTrue;

    RelationalSymbolicValue(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        this.relationWhenTrue = new Relation(kind, leftOperand, rightOperand);
    }

    public static SymbolicValue create(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        if (EQUALITY_KINDS.contains((Object)kind)) {
            return RelationalSymbolicValue.createEquality(kind, leftOperand, rightOperand);
        }
        return new RelationalSymbolicValue(kind, leftOperand, rightOperand);
    }

    private static SymbolicValue createEquality(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        TypeOfComparisonSymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.create(leftOperand, rightOperand);
        if (typeOfComparison != null) {
            return EqualitySymbolicValue.NEGATION_KINDS.contains((Object)kind) ? LogicalNotSymbolicValue.create(typeOfComparison) : typeOfComparison;
        }
        return new EqualitySymbolicValue(kind, leftOperand, rightOperand);
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            return RelationalSymbolicValue.checkRelationsAndConstrain(state, this.relationWhenTrue);
        }
        if (constraint.isStricterOrEqualTo(Constraint.FALSY)) {
            return RelationalSymbolicValue.checkRelationsAndConstrain(state, this.relationWhenTrue.not());
        }
        return Optional.of(state);
    }

    private static Optional<ProgramState> checkRelationsAndConstrain(ProgramState state, Relation relation) {
        for (Relation existingRelation : state.relations()) {
            if (relation.isCompatibleWith(existingRelation)) continue;
            return Optional.empty();
        }
        return Optional.of(state.addRelation(relation));
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return Constraint.BOOLEAN;
    }

    public Relation relationWhenTrue() {
        return this.relationWhenTrue;
    }

    public String toString() {
        return this.relationWhenTrue.toString();
    }
}

