/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.LiteralSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.TypeOfSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class TypeOfComparisonSymbolicValue
implements SymbolicValue {
    private final TypeOfSymbolicValue typeOfOperand;
    private final String comparedTypeString;
    private static final Map<String, Constraint> TYPEOF_EQUAL_CONSTRAINTS = ImmutableMap.builder().put((Object)"undefined", (Object)Constraint.UNDEFINED).put((Object)"function", (Object)Constraint.FUNCTION).put((Object)"object", (Object)Constraint.NULL.or(Constraint.OTHER_OBJECT).or(Constraint.ARRAY)).put((Object)"number", (Object)Constraint.NUMBER).put((Object)"string", (Object)Constraint.STRING).put((Object)"boolean", (Object)Constraint.BOOLEAN).put((Object)"symbol", (Object)Constraint.OTHER_OBJECT).put((Object)"date", (Object)Constraint.ANY_VALUE).put((Object)"unknown", (Object)Constraint.ANY_VALUE).build();

    private TypeOfComparisonSymbolicValue(TypeOfSymbolicValue typeOfOperand, String comparedTypeString) {
        Preconditions.checkArgument((typeOfOperand != null ? 1 : 0) != 0, (Object)"operandValue should not be null");
        Preconditions.checkArgument((comparedTypeString != null ? 1 : 0) != 0, (Object)"comparedTypeString should not be null");
        this.typeOfOperand = typeOfOperand;
        this.comparedTypeString = comparedTypeString;
    }

    @CheckForNull
    public static TypeOfComparisonSymbolicValue create(SymbolicValue operand1, SymbolicValue operand2) {
        TypeOfComparisonSymbolicValue typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand1, operand2);
        if (typeOfComparison == null) {
            typeOfComparison = TypeOfComparisonSymbolicValue.createTypeOfComparison(operand2, operand1);
        }
        return typeOfComparison;
    }

    @CheckForNull
    private static TypeOfComparisonSymbolicValue createTypeOfComparison(SymbolicValue operand1, SymbolicValue operand2) {
        LiteralTree literal;
        if (operand1 instanceof TypeOfSymbolicValue && operand2 instanceof LiteralSymbolicValue && (literal = ((LiteralSymbolicValue)operand2).getLiteral()).is(Tree.Kind.STRING_LITERAL)) {
            return new TypeOfComparisonSymbolicValue((TypeOfSymbolicValue)operand1, literal.value().substring(1, literal.value().length() - 1));
        }
        return null;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        Constraint truthyConstraint = TYPEOF_EQUAL_CONSTRAINTS.get(this.comparedTypeString);
        if (truthyConstraint == null || !truthyConstraint.equals(Constraint.ANY_VALUE)) {
            if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
                return truthyConstraint != null ? state.constrain(this.typeOfOperand.operandValue(), truthyConstraint) : Optional.empty();
            }
            if (constraint.isStricterOrEqualTo(Constraint.FALSY) && truthyConstraint != null) {
                return state.constrain(this.typeOfOperand.operandValue(), truthyConstraint.not());
            }
        }
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return Constraint.BOOLEAN;
    }

    public String toString() {
        return this.typeOfOperand + " == '" + this.comparedTypeString + "'";
    }
}

