/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ReturnStatementTreeImpl
extends JavaScriptTree
implements ReturnStatementTree {
    private SyntaxToken returnKeyword;
    private ExpressionTree expression;
    private final SyntaxToken semicolonToken;

    public ReturnStatementTreeImpl(@Nullable SyntaxToken semicolonToken) {
        this.semicolonToken = semicolonToken;
    }

    public ReturnStatementTreeImpl(ExpressionTree expression, @Nullable SyntaxToken semicolonToken) {
        this.expression = expression;
        this.semicolonToken = semicolonToken;
    }

    public ReturnStatementTreeImpl complete(InternalSyntaxToken returnKeyword) {
        Preconditions.checkState((this.returnKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.returnKeyword = returnKeyword;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STATEMENT;
    }

    @Override
    public SyntaxToken returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.returnKeyword, this.expression, this.semicolonToken});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitReturnStatement(this);
    }
}

