/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.ImmutableSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;

public class Relation {
    private final Operator operator;
    private final SymbolicValue leftOperand;
    private final SymbolicValue rightOperand;
    private final Set<SymbolicValue> operands;

    public Relation(Tree.Kind kind, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        this(Operator.fromKind(kind), leftOperand, rightOperand);
    }

    private Relation(Operator operator, SymbolicValue leftOperand, SymbolicValue rightOperand) {
        this.operator = operator;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.operands = ImmutableSet.of((Object)leftOperand, (Object)rightOperand);
    }

    public Relation not() {
        return new Relation(this.operator.not(), this.leftOperand, this.rightOperand);
    }

    public boolean isCompatibleWith(Relation other) {
        boolean result = true;
        if (other.leftOperand.equals(this.leftOperand) && other.rightOperand.equals(this.rightOperand)) {
            result = other.operator.isCompatibleForSameOperands(this.operator);
        } else if (other.leftOperand.equals(this.rightOperand) && other.rightOperand.equals(this.leftOperand)) {
            result = other.operator.isCompatibleForSameOperands(this.operator.onReversedOperands());
        }
        return result;
    }

    public Set<SymbolicValue> operands() {
        return this.operands;
    }

    public SymbolicValue leftOperand() {
        return this.leftOperand;
    }

    public SymbolicValue rightOperand() {
        return this.rightOperand;
    }

    public Operator operator() {
        return this.operator;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Relation) {
            Relation other = (Relation)obj;
            return Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.leftOperand, other.leftOperand) && Objects.equals(this.rightOperand, other.rightOperand);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.leftOperand, this.rightOperand});
    }

    public String toString() {
        return this.leftOperand + " " + this.operator.operatorString() + " " + this.rightOperand;
    }

    public static enum Operator {
        EQUAL_TO("==", Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.STRICT_EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO))),
        NOT_EQUAL_TO("!=", Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN), (Object)((Object)Tree.Kind.GREATER_THAN), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO))),
        STRICT_EQUAL_TO("===", Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO))),
        STRICT_NOT_EQUAL_TO("!==", Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN), (Object)((Object)Tree.Kind.GREATER_THAN), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO), (Object)((Object)Tree.Kind.EQUAL_TO), (Object[])new Tree.Kind[0])),
        LESS_THAN("<", Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO))),
        GREATER_THAN(">", Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO))),
        LESS_THAN_OR_EQUAL_TO("<=", Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_EQUAL_TO), (Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO), (Object)((Object)Tree.Kind.LESS_THAN), (Object)((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO), (Object[])new Tree.Kind[0])),
        GREATER_THAN_OR_EQUAL_TO(">=", Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, (Set<Tree.Kind>)ImmutableSet.of((Object)((Object)Tree.Kind.EQUAL_TO), (Object)((Object)Tree.Kind.NOT_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_EQUAL_TO), (Object)((Object)Tree.Kind.STRICT_NOT_EQUAL_TO), (Object)((Object)Tree.Kind.GREATER_THAN), (Object)((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO), (Object[])new Tree.Kind[0]));

        private final String operatorString;
        private final Tree.Kind kind;
        private final Tree.Kind negatedKind;
        private final Tree.Kind kindForReversedOperands;
        private final Set<Tree.Kind> compatibleKindsForSameOperands;
        private static final Map<Tree.Kind, Operator> OPERATOR_BY_KIND;

        private Operator(String operatorString, Tree.Kind kind, Tree.Kind negatedKind, Tree.Kind kindForReversedOperands, Set<Tree.Kind> compatibleKindsForSameOperands) {
            this.operatorString = operatorString;
            this.kind = kind;
            this.negatedKind = negatedKind;
            this.kindForReversedOperands = kindForReversedOperands;
            this.compatibleKindsForSameOperands = compatibleKindsForSameOperands;
        }

        private static Map<Tree.Kind, Operator> buildOperatorByKind() {
            EnumMap<Tree.Kind, Operator> map = new EnumMap<Tree.Kind, Operator>(Tree.Kind.class);
            for (Operator value : Operator.values()) {
                map.put(value.kind, value);
            }
            return map;
        }

        private static Operator fromKind(Tree.Kind kind) {
            return OPERATOR_BY_KIND.get((Object)kind);
        }

        public boolean isCompatibleForSameOperands(Operator other) {
            return this == other || this.compatibleKindsForSameOperands.contains((Object)other.kind);
        }

        public Operator onReversedOperands() {
            return Operator.fromKind(this.kindForReversedOperands);
        }

        public Operator not() {
            return Operator.fromKind(this.negatedKind);
        }

        public String operatorString() {
            return this.operatorString;
        }

        static {
            OPERATOR_BY_KIND = Operator.buildOperatorByKind();
        }
    }
}

