/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.builtins.ArrayBuiltInProperties;
import org.sonar.javascript.se.builtins.BooleanBuiltInProperties;
import org.sonar.javascript.se.builtins.BuiltInProperties;
import org.sonar.javascript.se.builtins.DateBuiltInProperties;
import org.sonar.javascript.se.builtins.FunctionBuiltInProperties;
import org.sonar.javascript.se.builtins.NullOrUndefinedBuiltInProperties;
import org.sonar.javascript.se.builtins.NumberBuiltInProperties;
import org.sonar.javascript.se.builtins.ObjectBuiltInProperties;
import org.sonar.javascript.se.builtins.RegexpBuiltInProperties;
import org.sonar.javascript.se.builtins.StringBuiltInProperties;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;

public enum Type {
    OBJECT(Constraint.OBJECT, null, new ObjectBuiltInProperties()),
    NUMBER_PRIMITIVE(Constraint.NUMBER_PRIMITIVE, OBJECT, NumberBuiltInProperties.INSTANCE),
    NUMBER_OBJECT(Constraint.NUMBER_OBJECT, OBJECT, NumberBuiltInProperties.INSTANCE),
    STRING_PRIMITIVE(Constraint.STRING_PRIMITIVE, OBJECT, StringBuiltInProperties.INSTANCE),
    STRING_OBJECT(Constraint.STRING_OBJECT, OBJECT, StringBuiltInProperties.INSTANCE),
    BOOLEAN_PRIMITIVE(Constraint.BOOLEAN_PRIMITIVE, OBJECT, BooleanBuiltInProperties.INSTANCE),
    BOOLEAN_OBJECT(Constraint.BOOLEAN_OBJECT, OBJECT, BooleanBuiltInProperties.INSTANCE),
    FUNCTION(Constraint.FUNCTION, OBJECT, new FunctionBuiltInProperties()),
    ARRAY(Constraint.ARRAY, OBJECT, new ArrayBuiltInProperties()),
    DATE(Constraint.DATE, OBJECT, new DateBuiltInProperties()),
    REGEXP(Constraint.REGEXP, OBJECT, new RegexpBuiltInProperties()),
    NULL(Constraint.NULL, null, new NullOrUndefinedBuiltInProperties()),
    UNDEFINED(Constraint.UNDEFINED, null, new NullOrUndefinedBuiltInProperties());

    public static final List<Constraint> ONE_NUMBER;
    public static final List<Constraint> STRING_NUMBER;
    public static final List<Constraint> NUMBER_STRING;
    public static final List<Constraint> NUMBER_NUMBER;
    public static final List<Constraint> EMPTY;
    public static final List<Constraint> ONE_STRING;
    public static final IntFunction<Constraint> TO_LOCALE_STRING_SIGNATURE;
    private static final List<Type> VALUES_REVERSED;
    private static final EnumSet<Type> PRIMITIVE_TYPES;
    private Constraint constraint;
    private BuiltInProperties builtInProperties;
    private Type parentType;

    private Type(Constraint constraint, Type parentType, BuiltInProperties builtInProperties) {
        this.constraint = constraint;
        this.builtInProperties = builtInProperties;
        this.parentType = parentType;
    }

    public Constraint constraint() {
        return this.constraint;
    }

    public Type parentType() {
        return this.parentType;
    }

    private SymbolicValue getValueFromPrototype(String propertyName) {
        if (this.parentType != null) {
            SymbolicValue valueForProperty = this.parentType.getValueForProperty(propertyName);
            if (valueForProperty.equals(UnknownSymbolicValue.UNKNOWN) && PRIMITIVE_TYPES.contains((Object)this)) {
                return SpecialSymbolicValue.UNDEFINED;
            }
            return valueForProperty;
        }
        return UnknownSymbolicValue.UNKNOWN;
    }

    public SymbolicValue getValueForProperty(String propertyName) {
        SymbolicValue valueForProperty = this.builtInProperties.getValueForProperty(propertyName);
        if (valueForProperty == null) {
            return this.getValueFromPrototype(propertyName);
        }
        return valueForProperty;
    }

    public Optional<SymbolicValue> getValueForOwnProperty(String name) {
        return this.builtInProperties.getValueForOwnProperty(name);
    }

    public static Type find(Constraint constraint) {
        for (Type type : VALUES_REVERSED) {
            if (!constraint.isStricterOrEqualTo(type.constraint())) continue;
            return type;
        }
        return null;
    }

    static {
        ONE_NUMBER = ImmutableList.of((Object)Constraint.ANY_NUMBER);
        STRING_NUMBER = ImmutableList.of((Object)Constraint.ANY_STRING, (Object)Constraint.ANY_NUMBER);
        NUMBER_STRING = ImmutableList.of((Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_STRING);
        NUMBER_NUMBER = ImmutableList.of((Object)Constraint.ANY_NUMBER, (Object)Constraint.ANY_NUMBER);
        EMPTY = ImmutableList.of();
        ONE_STRING = ImmutableList.of((Object)Constraint.ANY_STRING);
        TO_LOCALE_STRING_SIGNATURE = parameterIndex -> {
            switch (parameterIndex) {
                case 0: {
                    return Constraint.ANY_STRING.or(Constraint.ARRAY);
                }
                case 1: {
                    return Constraint.OBJECT;
                }
            }
            return null;
        };
        VALUES_REVERSED = Lists.reverse(Arrays.asList(Type.values()));
        PRIMITIVE_TYPES = EnumSet.of(NUMBER_PRIMITIVE, new Type[]{NUMBER_OBJECT, STRING_PRIMITIVE, STRING_OBJECT, BOOLEAN_PRIMITIVE, BOOLEAN_OBJECT});
    }
}

