/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.builtins.MathBuiltInObjectSymbolicValue;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.FunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

public enum BuiltInObjectSymbolicValue implements FunctionSymbolicValue
{
    NUMBER("Number", Type.NUMBER_OBJECT),
    BOOLEAN("Boolean", Type.BOOLEAN_OBJECT),
    STRING("String", Type.STRING_OBJECT),
    FUNCTION("Function", Type.FUNCTION),
    DATE("Date", Type.DATE),
    REGEXP("RegExp", Type.REGEXP),
    ARRAY("Array", Type.ARRAY),
    OBJECT("Object", Type.OBJECT);

    private static final BuiltInFunctionSymbolicValue.ArgumentsConstrainer IS_NAN_ARGUMENT_CONSTRAINER;
    private static final Map<String, SymbolicValue> ADDITIONAL_VALUES;
    private final String name;
    private final Type type;

    private BuiltInObjectSymbolicValue(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public Optional<SymbolicValue> getValueForOwnProperty(String name) {
        return this.type.getValueForOwnProperty(name);
    }

    @Override
    public SymbolicValue instantiate() {
        return new SymbolicValueWithConstraint(this.type.constraint());
    }

    @Override
    public SymbolicValue call(List<SymbolicValue> argumentValues) {
        if (this == DATE || this == STRING) {
            return new SymbolicValueWithConstraint(Constraint.STRING_PRIMITIVE);
        }
        if (this == NUMBER) {
            return new SymbolicValueWithConstraint(Constraint.NUMBER_PRIMITIVE);
        }
        if (this == BOOLEAN) {
            return new SymbolicValueWithConstraint(Constraint.BOOLEAN_PRIMITIVE);
        }
        return new SymbolicValueWithConstraint(this.type.constraint());
    }

    public static Optional<SymbolicValue> find(String name) {
        for (BuiltInObjectSymbolicValue builtInObject : BuiltInObjectSymbolicValue.values()) {
            if (!builtInObject.name.equals(name)) continue;
            return Optional.of(builtInObject);
        }
        if (ADDITIONAL_VALUES.containsKey(name)) {
            return Optional.of(ADDITIONAL_VALUES.get(name));
        }
        return Optional.empty();
    }

    static {
        IS_NAN_ARGUMENT_CONSTRAINER = (arguments, state, constraint) -> {
            boolean truthy = constraint.isStricterOrEqualTo(Constraint.TRUTHY);
            boolean hasArguments = !arguments.isEmpty();
            Constraint alwaysNaN = Constraint.UNDEFINED.or(Constraint.NAN).or(Constraint.FUNCTION).or(Constraint.REGEXP).or(Constraint.OTHER_OBJECT);
            Constraint alwaysNotNaN = Constraint.NULL.or(Constraint.ZERO).or(Constraint.EMPTY_STRING_PRIMITIVE).or(Constraint.ANY_BOOLEAN).or(Constraint.TRUTHY_NUMBER_PRIMITIVE);
            if (truthy && hasArguments) {
                return state.constrain((SymbolicValue)arguments.get(0), alwaysNotNaN.not());
            }
            if (truthy) {
                return Optional.of(state);
            }
            if (!hasArguments) {
                return Optional.empty();
            }
            return state.constrain((SymbolicValue)arguments.get(0), alwaysNaN.not());
        };
        ADDITIONAL_VALUES = ImmutableMap.of((Object)"Math", (Object)new MathBuiltInObjectSymbolicValue(), (Object)"isNaN", (Object)new BuiltInFunctionSymbolicValue(Constraint.BOOLEAN_PRIMITIVE, IS_NAN_ARGUMENT_CONSTRAINER, index -> index == 0 ? Constraint.ANY_VALUE : null, false), (Object)"NaN", (Object)new SymbolicValueWithConstraint(Constraint.NAN));
    }
}

