/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

public abstract class BuiltInProperties {
    abstract Map<String, Constraint> getPropertiesConstraints();

    abstract Map<String, SymbolicValue> getMethods();

    abstract Map<String, Constraint> getOwnPropertiesConstraints();

    abstract Map<String, SymbolicValue> getOwnMethods();

    @Nullable
    public SymbolicValue getValueForProperty(String propertyName) {
        Constraint constraint = this.getPropertiesConstraints().get(propertyName);
        if (constraint != null) {
            return new SymbolicValueWithConstraint(constraint);
        }
        SymbolicValue value = this.getMethods().get(propertyName);
        if (value != null) {
            return value;
        }
        return null;
    }

    public Optional<SymbolicValue> getValueForOwnProperty(String name) {
        Constraint constraint = this.getOwnPropertiesConstraints().get(name);
        if (constraint != null) {
            return Optional.of(new SymbolicValueWithConstraint(constraint));
        }
        SymbolicValue value = this.getOwnMethods().get(name);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint) {
        return new BuiltInFunctionSymbolicValue(returnConstraint);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, List<Constraint> parameterTypes) {
        return BuiltInProperties.method(returnConstraint, null, parameterTypes, false);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, List<Constraint> parameterTypes, boolean hasSideEffect) {
        return BuiltInProperties.method(returnConstraint, null, parameterTypes, hasSideEffect);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, IntFunction<Constraint> signature) {
        return new BuiltInFunctionSymbolicValue(returnConstraint, signature, false);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, IntFunction<Constraint> signature, boolean hasSideEffect) {
        return new BuiltInFunctionSymbolicValue(returnConstraint, signature, hasSideEffect);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, @Nullable BuiltInFunctionSymbolicValue.ArgumentsConstrainer argumentsConstrainer, List<Constraint> parameterTypes) {
        return new BuiltInFunctionSymbolicValue(returnConstraint, argumentsConstrainer, new BuiltInFunctionSymbolicValue.ListSignature(parameterTypes), false);
    }

    protected static BuiltInFunctionSymbolicValue method(Constraint returnConstraint, @Nullable BuiltInFunctionSymbolicValue.ArgumentsConstrainer argumentsConstrainer, List<Constraint> parameterTypes, boolean hasSideEffect) {
        return new BuiltInFunctionSymbolicValue(returnConstraint, argumentsConstrainer, new BuiltInFunctionSymbolicValue.ListSignature(parameterTypes), hasSideEffect);
    }

    protected static Constraint constraintOnRecentProperty(Constraint baseConstraint) {
        return baseConstraint.or(Constraint.UNDEFINED);
    }

    public static BuiltInFunctionSymbolicValue.ArgumentsConstrainer getIsSomethingArgumentsConstrainer(Constraint logicConstraint) {
        return (arguments, state, constraint2) -> {
            boolean hasArguments;
            boolean truthy = constraint2.isStricterOrEqualTo(Constraint.TRUTHY);
            boolean bl = hasArguments = !arguments.isEmpty();
            if (truthy && !hasArguments) {
                return Optional.empty();
            }
            if (truthy) {
                return state.constrain((SymbolicValue)arguments.get(0), logicConstraint);
            }
            if (!hasArguments) {
                return Optional.of(state);
            }
            return state.constrain((SymbolicValue)arguments.get(0), logicConstraint.not());
        };
    }
}

