/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.builtins.BuiltInProperties;
import org.sonar.javascript.se.sv.ObjectSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

public class MathBuiltInObjectSymbolicValue
implements ObjectSymbolicValue {
    private static final BuiltInProperties PROPERTIES = new MathBuiltInProperties();

    @Override
    public Optional<SymbolicValue> getValueForOwnProperty(String name) {
        Constraint constraint = PROPERTIES.getOwnPropertiesConstraints().get(name);
        if (constraint != null) {
            return Optional.of(new SymbolicValueWithConstraint(constraint));
        }
        SymbolicValue value = PROPERTIES.getOwnMethods().get(name);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return Constraint.OTHER_OBJECT;
    }

    private static class MathBuiltInProperties
    extends BuiltInProperties {
        private MathBuiltInProperties() {
        }

        @Override
        Map<String, Constraint> getPropertiesConstraints() {
            throw new IllegalStateException("Math is not function object, so it can't be instantiated.");
        }

        @Override
        Map<String, SymbolicValue> getMethods() {
            throw new IllegalStateException("Math is not function object, so it can't be instantiated.");
        }

        @Override
        Map<String, Constraint> getOwnPropertiesConstraints() {
            return ImmutableMap.builder().put((Object)"E", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"LN2", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"LN10", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"LOG2E", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"LOG10E", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"PI", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"SQRT1_2", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).put((Object)"SQRT2", (Object)Constraint.TRUTHY_NUMBER_PRIMITIVE).build();
        }

        @Override
        Map<String, SymbolicValue> getOwnMethods() {
            IntFunction<Constraint> numbersSignature = parameterIndex -> Constraint.ANY_NUMBER;
            return ImmutableMap.builder().put((Object)"abs", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"acos", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"acosh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"asin", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"asinh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"atan", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"atanh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"atan2", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"cbrt", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"ceil", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"clz32", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"cos", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"cosh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"exp", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"expm1", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"floor", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"fround", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"hypot", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, numbersSignature)).put((Object)"imul", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"log", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"log1p", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"log10", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"log2", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"max", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, numbersSignature)).put((Object)"min", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, numbersSignature)).put((Object)"pow", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"random", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.EMPTY)).put((Object)"round", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"sign", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"sin", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"sinh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"sqrt", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"tan", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"tanh", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"trunc", (Object)MathBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).build();
        }
    }
}

