/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.builtins.BuiltInProperties;
import org.sonar.javascript.se.sv.SymbolicValue;

public class StringBuiltInProperties
extends BuiltInProperties {
    public static final StringBuiltInProperties INSTANCE = new StringBuiltInProperties();

    private StringBuiltInProperties() {
    }

    @Override
    Map<String, SymbolicValue> getMethods() {
        IntFunction<Constraint> localeCompareSignature = parameterIndex -> {
            switch (parameterIndex) {
                case 0: {
                    return Constraint.ANY_STRING;
                }
                case 1: {
                    return Constraint.ANY_STRING.or(Constraint.ARRAY);
                }
                case 2: {
                    return Constraint.OBJECT;
                }
            }
            return null;
        };
        IntFunction<Constraint> replaceSignature = parameterIndex -> {
            switch (parameterIndex) {
                case 0: {
                    return Constraint.ANY_STRING.or(Constraint.REGEXP);
                }
                case 1: {
                    return Constraint.ANY_STRING.or(Constraint.FUNCTION);
                }
            }
            return null;
        };
        return ImmutableMap.builder().put((Object)"charAt", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"charCodeAt", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"codePointAt", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"concat", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, (int parameterIndex) -> Constraint.ANY_STRING)).put((Object)"includes", (Object)StringBuiltInProperties.method(Constraint.BOOLEAN_PRIMITIVE, Type.STRING_NUMBER)).put((Object)"endsWith", (Object)StringBuiltInProperties.method(Constraint.BOOLEAN_PRIMITIVE, Type.STRING_NUMBER)).put((Object)"indexOf", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.STRING_NUMBER)).put((Object)"lastIndexOf", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, Type.STRING_NUMBER)).put((Object)"localeCompare", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, localeCompareSignature)).put((Object)"match", (Object)StringBuiltInProperties.method(Constraint.ARRAY.or(Constraint.NULL), (List<Constraint>)ImmutableList.of((Object)Constraint.REGEXP))).put((Object)"normalize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_STRING)).put((Object)"padEnd", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.NUMBER_STRING)).put((Object)"padStart", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.NUMBER_STRING)).put((Object)"repeat", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"replace", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, replaceSignature)).put((Object)"search", (Object)StringBuiltInProperties.method(Constraint.NUMBER_PRIMITIVE, (List<Constraint>)ImmutableList.of((Object)Constraint.REGEXP))).put((Object)"slice", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"split", (Object)StringBuiltInProperties.method(Constraint.ARRAY, (List<Constraint>)ImmutableList.of((Object)Constraint.ANY_STRING.or(Constraint.REGEXP), (Object)Constraint.ANY_NUMBER))).put((Object)"startsWith", (Object)StringBuiltInProperties.method(Constraint.BOOLEAN_PRIMITIVE, Type.STRING_NUMBER)).put((Object)"substr", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"substring", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.NUMBER_NUMBER)).put((Object)"toLocaleLowerCase", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"toLocaleUpperCase", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"toLowerCase", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"toUpperCase", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"trim", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"toString", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"valueOf", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"anchor", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_STRING)).put((Object)"big", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"blink", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"bold", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"fixed", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"fontcolor", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_STRING)).put((Object)"fontsize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_NUMBER)).put((Object)"italics", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"link", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.ONE_STRING)).put((Object)"small", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"strike", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"sub", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"sup", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, Type.EMPTY)).put((Object)"camelize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"capitalize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"classify", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"dasherize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"decamelize", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"fmt", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"loc", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"underscore", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).put((Object)"w", (Object)StringBuiltInProperties.method(Constraint.ARRAY)).build();
    }

    @Override
    Map<String, Constraint> getPropertiesConstraints() {
        return ImmutableMap.of((Object)"length", (Object)Constraint.NUMBER_PRIMITIVE);
    }

    @Override
    Map<String, SymbolicValue> getOwnMethods() {
        IntFunction<Constraint> numbersSignature = parameterIndex -> Constraint.ANY_NUMBER;
        return ImmutableMap.builder().put((Object)"fromCharCode", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, numbersSignature)).put((Object)"fromCodePoint", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE, numbersSignature)).put((Object)"raw", (Object)StringBuiltInProperties.method(Constraint.STRING_PRIMITIVE)).build();
    }

    @Override
    Map<String, Constraint> getOwnPropertiesConstraints() {
        return ImmutableMap.of();
    }
}

