/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.builtins.BuiltInObjectSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;

public class InstanceOfSymbolicValue
implements SymbolicValue {
    private static final Constraint PRIMITIVE = Constraint.NUMBER_PRIMITIVE.or(Constraint.BOOLEAN_PRIMITIVE).or(Constraint.STRING_PRIMITIVE);
    private final SymbolicValue objectValue;
    private final SymbolicValue constructorValue;

    public InstanceOfSymbolicValue(SymbolicValue objectValue, SymbolicValue constructorValue) {
        this.objectValue = objectValue;
        this.constructorValue = constructorValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        Optional<ProgramState> newProgramState;
        Constraint constraintForObject = null;
        if (this.constructorValue instanceof BuiltInObjectSymbolicValue) {
            constraintForObject = ((BuiltInObjectSymbolicValue)this.constructorValue).type().constraint();
        }
        if (constraint.isStricterOrEqualTo(Constraint.TRUTHY)) {
            newProgramState = state.constrain(this.objectValue, constraintForObject == null ? Constraint.NOT_NULLY : constraintForObject);
        } else {
            constraintForObject = constraintForObject == null || constraintForObject.equals(Constraint.OBJECT) ? Constraint.ANY_VALUE : constraintForObject.not();
            newProgramState = state.constrain(this.objectValue, constraintForObject);
        }
        return newProgramState;
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint objectConstraint = state.getConstraint(this.objectValue);
        if (objectConstraint.isStricterOrEqualTo(PRIMITIVE)) {
            return Constraint.FALSE;
        }
        Type objectType = objectConstraint.type();
        if (objectType != null && this.constructorValue instanceof BuiltInObjectSymbolicValue) {
            Type constructorType = ((BuiltInObjectSymbolicValue)this.constructorValue).type();
            return InstanceOfSymbolicValue.resolveConstraint(objectType, constructorType);
        }
        return Constraint.BOOLEAN_PRIMITIVE;
    }

    private static Constraint resolveConstraint(Type objectType, Type constructorType) {
        if (objectType == Type.OBJECT) {
            return Constraint.BOOLEAN_PRIMITIVE;
        }
        for (Type currentType = objectType; currentType != null; currentType = currentType.parentType()) {
            if (constructorType != currentType) continue;
            return Constraint.TRUE;
        }
        return Constraint.FALSE;
    }

    public String toString() {
        return this.objectValue + " instanceof " + this.constructorValue;
    }
}

