/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;

public class PlusSymbolicValue
implements SymbolicValue {
    private final SymbolicValue firstOperandValue;
    private final SymbolicValue secondOperandValue;

    public PlusSymbolicValue(SymbolicValue firstOperandValue, SymbolicValue secondOperandValue) {
        Preconditions.checkArgument((firstOperandValue != null ? 1 : 0) != 0, (Object)"operand value should not be null");
        Preconditions.checkArgument((secondOperandValue != null ? 1 : 0) != 0, (Object)"operand value should not be null");
        this.firstOperandValue = firstOperandValue;
        this.secondOperandValue = secondOperandValue;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        Constraint numberOrBoolean = Constraint.NUMBER_PRIMITIVE.or(Constraint.BOOLEAN_PRIMITIVE);
        Constraint firstConstraint = state.getConstraint(this.firstOperandValue);
        Constraint secondConstraint = state.getConstraint(this.secondOperandValue);
        if (firstConstraint.isStricterOrEqualTo(Constraint.ANY_STRING) || secondConstraint.isStricterOrEqualTo(Constraint.ANY_STRING)) {
            return Constraint.STRING_PRIMITIVE;
        }
        if (firstConstraint.isStricterOrEqualTo(numberOrBoolean) && secondConstraint.isStricterOrEqualTo(numberOrBoolean)) {
            return Constraint.NUMBER_PRIMITIVE;
        }
        return Constraint.NUMBER_PRIMITIVE.or(Constraint.STRING_PRIMITIVE);
    }

    public String toString() {
        return this.firstOperandValue + " + " + this.secondOperandValue;
    }
}

