/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl;

import java.util.Iterator;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public abstract class JavaScriptTree
implements Tree {
    private Tree parent;

    public int getLine() {
        return this.getFirstToken().line();
    }

    @Override
    public final boolean is(Tree.Kind ... kind) {
        if (this.getKind() != null) {
            for (Tree.Kind kindIter : kind) {
                if (this.getKind() != kindIter) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Tree.Kind getKind();

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public SyntaxToken getLastToken() {
        SyntaxToken lastToken = null;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        while (childrenIterator.hasNext()) {
            SyntaxToken childLastToken;
            JavaScriptTree child = (JavaScriptTree)childrenIterator.next();
            if (child == null || (childLastToken = child.getLastToken()) == null) continue;
            lastToken = childLastToken;
        }
        return lastToken;
    }

    public SyntaxToken getFirstToken() {
        Tree child;
        Iterator<Tree> childrenIterator = this.childrenIterator();
        do {
            if (!childrenIterator.hasNext()) {
                throw new IllegalStateException("Tree has no non-null children " + (Object)((Object)this.getKind()));
            }
            child = childrenIterator.next();
        } while (child == null);
        return ((JavaScriptTree)child).getFirstToken();
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public Tree getParent() {
        return this.parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Tree> children = this.childrenIterator();
        while (children.hasNext()) {
            sb.append(children.next());
            sb.append(" ");
        }
        return sb.toString();
    }
}

