/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.statement;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class CaseClauseTreeImpl
extends JavaScriptTree
implements CaseClauseTree {
    private final SyntaxToken caseKeyword;
    private final ExpressionTree expression;
    private final SyntaxToken colon;
    private final List<StatementTree> statements;

    public CaseClauseTreeImpl(InternalSyntaxToken caseKeyword, ExpressionTree expression, InternalSyntaxToken colon) {
        this.caseKeyword = caseKeyword;
        this.expression = expression;
        this.colon = colon;
        this.statements = Collections.emptyList();
    }

    public CaseClauseTreeImpl(InternalSyntaxToken caseKeyword, ExpressionTree expression, InternalSyntaxToken colon, List<StatementTree> statements) {
        this.caseKeyword = caseKeyword;
        this.expression = expression;
        this.colon = colon;
        this.statements = statements;
    }

    @Override
    public SyntaxToken keyword() {
        return this.caseKeyword;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken colon() {
        return this.colon;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CASE_CLAUSE;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.caseKeyword, this.expression, this.colon}), this.statements.iterator());
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitCaseClause(this);
    }
}

