/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;

public class LiteralSymbolicValue
implements SymbolicValue {
    private final LiteralTree literal;
    private final Constraint constraint;

    private LiteralSymbolicValue(LiteralTree literal) {
        this.literal = literal;
        this.constraint = LiteralSymbolicValue.getConstraint(literal);
    }

    public static LiteralSymbolicValue get(LiteralTree literal) {
        return new LiteralSymbolicValue(literal);
    }

    public LiteralTree getLiteral() {
        return this.literal;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        if (this.baseConstraint(state).isIncompatibleWith(constraint)) {
            return Optional.empty();
        }
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return this.constraint;
    }

    private static Constraint getConstraint(LiteralTree literal) {
        Constraint result = null;
        if (literal.is(Tree.Kind.BOOLEAN_LITERAL)) {
            Constraint constraint = result = "true".equals(literal.value()) ? Constraint.TRUE : Constraint.FALSE;
        }
        if (literal.is(Tree.Kind.STRING_LITERAL)) {
            Constraint constraint = result = literal.value().length() > 2 ? Constraint.TRUTHY_STRING_PRIMITIVE : Constraint.EMPTY_STRING_PRIMITIVE;
        }
        if (literal.is(Tree.Kind.NUMERIC_LITERAL)) {
            Constraint constraint = result = LiteralSymbolicValue.isTruthyNumeric(literal) ? Constraint.TRUTHY_NUMBER_PRIMITIVE : Constraint.ZERO;
        }
        if (literal.is(Tree.Kind.REGULAR_EXPRESSION_LITERAL)) {
            result = Constraint.REGEXP;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Unknown literal: " + literal);
    }

    private static boolean isTruthyNumeric(LiteralTree literal) {
        String stringValue = literal.value();
        if (stringValue.startsWith("0x") || stringValue.startsWith("0b") || stringValue.startsWith("0o") || stringValue.startsWith("0O")) {
            return LiteralSymbolicValue.hasNonZero(stringValue.substring(2));
        }
        int exponentIndex = stringValue.indexOf(101);
        if (exponentIndex == -1) {
            exponentIndex = stringValue.indexOf(69);
        }
        if (exponentIndex > -1) {
            stringValue = stringValue.substring(0, exponentIndex);
        }
        return LiteralSymbolicValue.hasNonZero(stringValue);
    }

    private static boolean hasNonZero(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '0' || c == '.') continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "LiteralSV " + this.literal.value();
    }
}

