/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class GlobalVariableNames {
    private static final Gson gson = new Gson();
    private static final String GLOBALS_FILE = "globals.json";
    public static final String ENVIRONMENTS_PROPERTY_KEY = "sonar.javascript.environments";
    public static final String ENVIRONMENTS_DEFAULT_VALUE = "amd, applescript, atomtest, browser, commonjs, couch, embertest, greasemonkey, jasmine, jest, jquery, meteor, mocha, mongo, nashorn, node, phantomjs, prototypejs, protractor, qunit, rhino, serviceworker, shared-node-browser, shelljs, webextensions, worker, wsh, yui";
    public static final String GLOBALS_PROPERTY_KEY = "sonar.javascript.globals";
    public static final String GLOBALS_DEFAULT_VALUE = "require,define,jQuery,$,angular,goog,google,OpenLayers,d3,dojo,dojox,dijit,Backbone,YUI,moment,casper";
    private static final Map<String, Set<String>> ENVIRONMENTS = GlobalVariableNames.environments();
    private static final Logger LOGGER = Loggers.get(GlobalVariableNames.class);
    private final Set<String> names;

    public GlobalVariableNames(@Nullable Settings settings) {
        ImmutableSet.Builder namesBuilder = ImmutableSet.builder();
        if (GlobalVariableNames.globalsFromEnvironment("builtin").isPresent()) {
            namesBuilder.addAll((Iterable)GlobalVariableNames.globalsFromEnvironment("builtin").get());
        }
        if (settings != null) {
            namesBuilder.add((Object[])settings.getStringArray(GLOBALS_PROPERTY_KEY));
            for (String environmentName : settings.getStringArray(ENVIRONMENTS_PROPERTY_KEY)) {
                Optional<Set<String>> namesFromCurrentEnvironment = GlobalVariableNames.globalsFromEnvironment(environmentName);
                if (namesFromCurrentEnvironment.isPresent()) {
                    namesBuilder.addAll((Iterable)namesFromCurrentEnvironment.get());
                    continue;
                }
                LOGGER.warn("sonar.javascript.environments contains an unknown environment: " + environmentName);
            }
        }
        this.names = namesBuilder.build();
    }

    private static Map<String, Set<String>> environments() {
        InputStream stream = GlobalVariableNames.class.getResourceAsStream(GLOBALS_FILE);
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            String str = CharStreams.toString((Readable)reader);
            Type stringStringMap = new TypeToken<Map<String, Set<String>>>(){}.getType();
            return (Map)gson.fromJson(str, stringStringMap);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load globals.json", e);
        }
    }

    public Set<String> names() {
        return this.names;
    }

    private static Optional<Set<String>> globalsFromEnvironment(String environment) {
        if (ENVIRONMENTS.containsKey(environment)) {
            return Optional.of(ENVIRONMENTS.get(environment));
        }
        return Optional.empty();
    }
}

